// ADC measure program
//
// PROCESSOR : PIC12F629
// CLOCK	 : 4MHz, EXTERNAL

#include	<pic.h>

__CONFIG(WDTDIS & MCLRDIS & BORDIS & XT & PWRTEN) ;
  
unsigned int result;

//Functions definitions
//-------------------------------------------------------------------

void Delay(unsigned char cntr)		//delay time = 4*(cntr-1)+10 
{
	while (--cntr != 0);
}

void InitADC(void) {

	INTCON 	= 0x00;			// Disable inerupt
	ANSEL   = 0x0f;			// Fosc/2, AN0-AN4 - analog input
	TRISIO  = 0x17;			// ADC pin as input	


}

unsigned int adc_read(unsigned char channel) {

	// Set chanel, Right justified, ADC ON
	ADCON0 = (channel << 3) | 0x81;
	// Start conversion
	GODONE = 1;
	// wait for conversion complete
	while(GODONE);
	// Return value
	return ((ADRESH<<8)|(ADRESL));	
	
}


// main function
void main( void ) {

	// Init ADC
	InitADC();
	
	// loop forever - echo plus one
	while(1) {
		result = adc_read(2);
		
	}
}
