//PROGRAMM FOR rs232 communication
//
// PROCESSOR : PIC16F877A
// CLOCK	 : 20MHz, EXTERNAL
// SPEED     : 9600 bps(1bit=104us)

#include	<pic.h>

__CONFIG(WDTDIS & LVPDIS & BORDIS & HS & PWRTEN) ;

unsigned char ch;

void InitUsart(void) {

	// TX Pin - output
	TRISC6 = 0;

	// RX Pin - input
	TRISC7 = 1;

	// RX Setting, 8bit, enable receive, 
	RCSTA = 0x90; 

	// TX Setting, 8bit, Asinchronius mode, High speed 
	TXSTA = 0x24;

	// Set Baudrade - 9600 (from datasheet baudrade table)
	SPBRG = 129;

}


void  WriteByte(unsigned char byte) {
	
	// wait until register is empty 
	while(!TXIF);

	// transmite byte	
	TXREG = byte;
}

unsigned char ReadByte(void) {
	
	// wait to receive character
	while(!RCIF);

	// return received character
	return RCREG;	
}


// main function
void main( void ) {

	// Init Interface
	InitUsart();

	// loop forever - echo 
	while(1) {
		ch = ReadByte();
		WriteByte(ch);
		WriteByte('*');
	}
}
