/*
 * TC-MK2.h
 * 
 * Copyright 2013 OLIMEX LTD/Stefan Mavrodiev <support@olimex.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef TC_MK2_H
#define TC_MK2_H

#include <inttypes.h>

#define SET_ADDRESS 	0xF0
#define GET_ID		0x20
#define SET_TRIS	0x01
#define SET_LAT		0x02
#define GET_PORT	0x03
#define SET_PU		0x04

#define GET_TEMP	0x21

#define	IN		1
#define	OUT		0
#define ON		1
#define OFF		0
#define LO		0
#define HI		1
#define ANALOG_0	0x10
#define ANALOG_1	0x11
#define ANALOG_2	0x12
#define ANALOG_6	0x16
#define ANALOG_7	0x17
#define GPIO_0	0x01
#define GPIO_1	0x02
#define GPIO_2	0x04
#define GPIO_3	0x08
#define GPIO_4	0x10
#define GPIO_5	0x20
#define GPIO_6	0x40
#define PU_0	0x01
#define PU_1	0x02
#define PU_2	0x04
#define PU_3	0x08
#define PU_4	0x10


class TC_MK2
{
    private:
    uint8_t address;	
	uint8_t tris_status;
	uint8_t lat_status;
	uint8_t pu_status;
    public:
	TC_MK2();
	TC_MK2(uint8_t addr);
	void pinMode(uint8_t pin, uint8_t mode);
	void digitalWrite(uint8_t pin, uint8_t level);
	uint8_t digitalRead(uint8_t pin);
	void pullupMode(uint8_t pin, uint8_t state);
	uint16_t analogRead(uint8_t channel);
	uint32_t temperatureRead(void);
	
	void setAddress(uint8_t newAddress);
	uint8_t getID(void);
};
#endif
