/**********************************************************************************/
/*    Demo program for:								  */
/*	  Board: MSP430-H5438     						  */
/*    Manufacture: OLIMEX                                                   	  */
/*	  COPYRIGHT (C) 2010							  */
/*    Designed by: Engineer Penko T. Bozhkov                                      */
/*    Module Name    :  main module                                               */
/*    File   Name    :  main.c                                                    */
/*    Revision       :  initial                                                   */
/*    Date           :  24.03.2010                                                */
/*    Built with IAR Embedded Workbench Version: 4.21                             */
/*   Toggle LED i.e. P10.7 with frequency ~ 1Hz.(DCO clock and TimerA1 interrupt) */
/**********************************************************************************/
#include <msp430x54x.h>
#include <intrinsics.h>

void Ports_initial_initialization(void);
void init_devices(void);

#define LED_ON                  P10OUT |= 0x80;  P10DIR |= 0x80;
#define LED_OFF                 P10OUT &= ~0x80; P10DIR |= 0x80;
#define LED_Check               (P10IN & 0x80)


/**********************************************************************************/
/*  Function name: Ports_initial_initialization                                   */
/*  	Parameters                                                                */
/*          Input   :  No	                                                  */
/*          Output  :  No	                                                  */
/*	Action: Define initial ports states and directions.			  */
/**********************************************************************************/
void Ports_initial_initialization(void)
{
   //input_data=P1IN;          //Read only register
  P1OUT = 0x00;               // The outputs are low
  P1SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P1DIR = 0x01;               // 1 -> Output; 0 -> Input; All inputs except LED 
  P1REN = 0x00;               // Pullup/pulldown resistor disabled
  P1DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  P1IES = 0x00;               // Interrupt Edge Select Registers
  P1IE = 0x00;                // Disable all PORTx interrupts
  P1IFG = 0x00;               // Clear all interrupt flags

   //input_data=P2IN;          //Read only register
  P2OUT = 0x00;               // The outputs are low
  P2SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P2DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P2REN = 0x00;               // Pullup/pulldown resistor disabled
  P2DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  P2IES = 0x00;               // Interrupt Edge Select Registers
  P2IE = 0x00;                // Disable all PORTx interrupts
  P2IFG = 0x00;               // Clear all interrupt flags

   //input_data=P3IN;          //Read only register
  P3OUT = 0x00;               // The outputs are low
  P3SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P3DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P3REN = 0x00;               // Pullup/pulldown resistor disabled
  P3DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength

  //input_data=P4IN;          //Read only register
  P4OUT = 0x00;               // The outputs are low
  P4SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P4DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P4REN = 0x00;               // Pullup/pulldown resistor disabled
  P4DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  
  //input_data=P5IN;          //Read only register
  P5OUT = 0x00;               // The outputs are low
  P5SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P5DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P5REN = 0x00;               // Pullup/pulldown resistor disabled
  P5DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  
  //input_data=P6IN;          //Read only register
  P6OUT = 0x00;               // The outputs are low
  P6SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P6DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P6REN = 0x00;               // Pullup/pulldown resistor disabled
  P6DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  
  //input_data=P7IN;          //Read only register
  P7OUT = 0x00;               // The outputs are low
  P7SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P7DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P7REN = 0x00;               // Pullup/pulldown resistor disabled
  P7DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  
  //input_data=P8IN;          //Read only register
  P8OUT = 0x00;               // The outputs are low
  P8SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P8DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P8REN = 0x00;               // Pullup/pulldown resistor disabled
  P8DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  
  //input_data=P9IN;          //Read only register
  P9OUT = 0x00;               // The outputs are low
  P9SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P9DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P9REN = 0x00;               // Pullup/pulldown resistor disabled
  P9DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  
  //input_data=P10IN;          //Read only register
  P10OUT = 0x00;               // The outputs are low
  P10SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P10DIR = 0x80;               // 1 -> Output; 0 -> Input; All inputs, except P10.7(LED)
  P10REN = 0x00;               // Pullup/pulldown resistor disabled
  P10DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
  
  //input_data=P11IN;          //Read only register
  P11OUT = 0x00;               // The outputs are low
  P11SEL = 0x00;               // Peripheral module function: I/O function is selected.
  P11DIR = 0x00;               // 1 -> Output; 0 -> Input; All inputs
  P11REN = 0x00;               // Pullup/pulldown resistor disabled
  P11DS =  0x00;               // 0 -> Reduced output drive strength; 1 -> Full output drive strength
}


/**********************************************************************************/
/*  Function name: init_devices	                                                  */
/*  	Parameters                                                                */
/*          Input   :  No			     		                  */
/*          Output  :  No                                      	            	  */
/*	Action: Initialize all used MSP430F5438 peripheral devices.	  	  */
/**********************************************************************************/
void init_devices(void){
  _BIC_SR(GIE); // Disable interrupts during initialization process
  
  /********** 1.Ports initialization ***********/
  Ports_initial_initialization();
  /********** 2.Peripherals initialization ***********/
  //2.0. Set system clock:
  // Default MCLK and SMCLK value is ~1.048576 MHz (fDCO = 2.097152 MHz)
  
  // 2.1. Timer_A
  // =============
  TA1CTL = 0x0004;   // Timer_A1 clear
  TA1CCTL0 = 0x0010; // Timer_A1 Capture/compare interrupt enable
  TA1CCR0 = 0xF424;  // Set TACCR0 value
  TA1CTL = 0x02D0;   // Selected: SMCLK, divider 1/8, Up mode

  _BIS_SR(GIE); // Global Interrupt enabled. Do this at the END of the initialization!!!!!!!!
}


/**********************************************************************************/
/*  Function name: main	                                                  	  */
/*  	Parameters                                                                */
/*          Input   :  No			     		                  */
/*          Output  :  No                                      	            	  */
/*	Action: Call "init_devices()" and then loop forever.	  		  */
/**********************************************************************************/
void main(void)
{
    WDTCTL = WDTPW + WDTHOLD;               // Stop watchdog timer
    init_devices();
    while(1){
     
  } 
}


/**********************************************************************************/
/*  Function name: TIMERA1_Capture_Compare_ISR                                 	  */
/*  	Parameters                                                                */
/*          Input   :  No			     		                  */
/*          Output  :  No                                      	            	  */
/*	Action: Switch over LED when interrupt occur.                             */
/**********************************************************************************/
#pragma vector=TIMER1_A0_VECTOR
__interrupt void TIMER_ISR(void)
{
  if(LED_Check ){
    LED_OFF;
  }
  else{
    LED_ON;
  }

}

