/*
  Modified the Cal-Eng example to work with 
  AVR-T32u4 and its Hardware Button
  
  The Arduino board acts like a keybord device and
  sends a message to the computer every
  time you press the Hardware button
 */

/*
//  Arduino code example modified for Cal-Eng StealthDuino! Leonardo
//  Changed input to be the Hall-effect sensor, and added the ACSCII "Keyboard.write(89);" function
//  in this case, a capital letter "Y"


//  With a non-StealthDuino! board, just temporarily touch pin D3 to +5V to toggle the input
//  The pull-down resistor described below isn't really needed.


// Make sure to open a blank Notepad window or similar to avoid messing up your sketch!

*/

/* 
 Keyboard Button test
 
 Sends a text string when a button is pressed.
 
 The circuit:
 * pushbutton attached from pin 3 to +5V
 * 10-kilohm resistor attached from pin 3 to ground
 
 created 24 Oct 2011
 by Tom Igoe
 
 This example code is in the public domain.
 
 http://www.arduino.cc/en/Tutorial/KeyboardButton
 */


//  Set the button

#define BUTTONINIT  DDRE  &= ~(1<<2)
#define BUTTONSTATE ((PINE & B00000100) != 0)

int previousButtonState = HIGH;   // for checking the state of a pushButton
int counter = 0;                  // button push counter

void setup() {
  // make the pushButton pin an input:
  BUTTONINIT;
}

void loop() {
  
  
  // Read the button pin on the Olimexino-32u4
  int buttonState = BUTTONSTATE;
  
      // if the button state has changed, 
  if ((buttonState != previousButtonState) 
      // and it's currently pressed:
   && (buttonState == HIGH)) {
      // increment the button counter
    counter++;
    
    
    // type out a message
    // First function types a capital "Y" (ACSCII code 89)    
    
    Keyboard.write(89);
    Keyboard.print("ou pressed the button: ");
    Keyboard.print(counter); 
    Keyboard.println(" times.");
    Keyboard.println("");    
  }
  
  // save the current button state for comparison next time:
  previousButtonState = buttonState; 
  
}
