
#include "DSP280x_Device.h"     // DSP280x Headerfile Include File
#include "DSP280x_Examples.h"   // DSP280x Examples Include File
#include "pin_test.h"

#define		_1ms		1000
#define		_100ms		1000000
#define		EXT			0
#define		MOTOR		1
#define		UEXT		2

//#define		PULL_PIN	1  
 

const unsigned long mask_portA_EXT1 = 0x0FFFF5FF&(~BIT0);    // pull pin GPIO0
const unsigned long mask_portB_EXT1 = 0x7;   
const unsigned long mask_portA_Motor_EXT = 0x0003F1FF&(~BIT0);    // pull pin GPIO0
const unsigned long mask_portB_Motor_EXT = 0x7;
const unsigned long mask_portA_UEXT = 0x000F0000&(~BIT16);    // pull pin GPIO16
const unsigned long mask_portB_UEXT = 0x3;
unsigned long 	mask_portA;
unsigned long  mask_portB;
unsigned char state_pA_vcc = 0;
unsigned char state_pB_vcc = 0;
unsigned char Number_Ext = 0;
unsigned long PULL_PIN;



unsigned char  Wait_For_Any_Key (void)
{
	while(SciaRegs.SCIFFRX.bit.RXFFST !=1) {;} // wait for ANY KEY
	return SciaRegs.SCIRXBUF.all;
}

void Stop (void)
{
unsigned char t=0;
EALLOW;
GpioCtrlRegs.GPADIR.all = 0;
GpioCtrlRegs.GPBDIR.all = 0;
EDIS;
t++;
while (1);
}

void TestExt(void)
{

//GPIO0 is pull pin
//// Test for VCC short circuit or unconected pins/////---------------------------------------

	unsigned long j = 0;
	unsigned long my_1 = 1; 
	unsigned char dec = 0;
	unsigned char number = 0;
	unsigned char test_flag = 0;

	scia_msg("\r\nBegin test EXTENSIONS\n\0");		   
    scia_msg("\r\nPUT EXTENSION AND PRESS ANY KEY\n\0");	
	Wait_For_Any_Key ();    

	mask_portA = mask_portA_EXT1;
	mask_portB = mask_portB_EXT1;

	EALLOW;
	PULL_PIN = BIT0;
	GpioDataRegs.GPACLEAR.all = PULL_PIN;				//clear pull_pin for other EXT
	GpioCtrlRegs.GPADIR.all = PULL_PIN;		    	//pull_pin is output
	
TEST_AGAIN:
	GpioCtrlRegs.GPAPUD.all = 0xFFFFFFFF;		//Disable GPIO pull-ups
	GpioCtrlRegs.GPBPUD.all = 0xFFFFFFFF;		//Disable GPIOB Pull-ups
	GpioCtrlRegs.GPBDIR.all = 0;	
	
	DELAY_US(_1ms);
	if((GpioDataRegs.GPADAT.all & mask_portA) != 0x0)  				// for GPIOA
	{ 
	  scia_msg("\r\nGPIOA_ERR\0");
	  test_flag=1;
	  Stop(); 
	}
	if ((GpioDataRegs.GPBDAT.all & mask_portB) != 0x0)
/*
	if (((GpioDataRegs.GPBDAT.bit.GPIO32) | 						//for GPIOB
		(GpioDataRegs.GPBDAT.bit.GPIO32) | 
		(GpioDataRegs.GPBDAT.bit.GPIO32)) != 0) 
*/
	{ 
	  scia_msg("\r\nGPIOB_ERR\0"); 
	  test_flag=1;
	  Stop(); 
	}

//// Test for GND short circuit or unconected pins/////---------------------------------------	    
	GpioDataRegs.GPASET.all = PULL_PIN;			//set pull_pin
	DELAY_US(_1ms);
	if((GpioDataRegs.GPADAT.all | ~mask_portA) != 0xFFFFFFFF)  				// for GPIOA
	{ 
		scia_msg("\r\nGPIOA_ERR\0");  
		test_flag=1;
		Stop(); 
	}
	if ((GpioDataRegs.GPBDAT.all | ~mask_portB) != 0xFFFFFFFF)
/*
	if (((GpioDataRegs.GPBDAT.bit.GPIO32) & 						//for GPIOB
		(GpioDataRegs.GPBDAT.bit.GPIO33) & 
		(GpioDataRegs.GPBDAT.bit.GPIO34)) == 0) 
*/
	
	{ 
		scia_msg("\r\nGPIOB_ERR\0"); 
		test_flag=1;
		Stop(); 
	}

// loop for GPIOA
 	for(j=0; j<32; j++) 
 	{
    	if(!((mask_portA)&(my_1<<j))) continue;

    	GpioDataRegs.GPACLEAR.all = (my_1<<j);
    	GpioCtrlRegs.GPADIR.all = (my_1<<j)|PULL_PIN;

    	// just simple delay
  		DELAY_US(_1ms);

    	// check for other zero at GPIOA
    	if((GpioDataRegs.GPADAT.all | (~mask_portA)) != ((0xFFFFFFFF)&(~(my_1<<j))))  
    		{ 
				dec = j/10;
				number = j%10;
				scia_msg("\r\nSHORT GPIOA\0");
				scia_xmit('0'+dec);	
				scia_xmit('0'+number);
				test_flag=1;
      			Stop();  
    		}

	// check for other zero at GPIOB
		if ((GpioDataRegs.GPBDAT.bit.GPIO32) == 0) 
		{scia_msg("\r\nSHORT GPIOB32\0"); test_flag=1; Stop(); }
		if ((GpioDataRegs.GPBDAT.bit.GPIO33) == 0) 
		{scia_msg("\r\nSHORT GPIOB33\0"); test_flag=1; Stop(); }
		if ((Number_Ext != UEXT)) if ((GpioDataRegs.GPBDAT.bit.GPIO34) == 0) 
		{scia_msg("\r\nSHORT GPIOB34\0"); test_flag=1; Stop(); }

    }

	// loop for GPIOB
	GpioDataRegs.GPASET.all = PULL_PIN;				//set pull_pin
	GpioCtrlRegs.GPADIR.all = PULL_PIN;		    	//pull_pin is output
 	for(j=0; j<3; j++) 
 	{
    	if(!((mask_portB)&(my_1<<j))) continue;

    	GpioDataRegs.GPBCLEAR.all = (my_1<<j);
    	GpioCtrlRegs.GPBDIR.all = (my_1<<j);

    	// just simple delay
  		DELAY_US(_1ms);

    	// check for other zero at GPIOA
    	if((GpioDataRegs.GPBDAT.all | (~mask_portB)) != ((0xFFFFFFFF)&(~(my_1<<j))))  
    		{ 
				scia_msg("\r\nSHORT GPIOB3\0");
				scia_xmit('2'+j);
				test_flag=1;
      			Stop();  
    		}

	// check for other zero at GPIOA
		if((GpioDataRegs.GPADAT.all | (~mask_portA)) != 0xFFFFFFFF)  				
			{ 
				scia_msg("\r\nShort GPIOA pin with GPIOB pin\0");  			//second  optional test
				Stop(); 
			}
		
    }
	
	if (Number_Ext == EXT)
	{
		if (test_flag == 0) scia_msg("\r\nTEST EXTENSION OK!!!\0");		
		Number_Ext = 1;
		mask_portA = mask_portA_Motor_EXT;
		mask_portB = mask_portB_Motor_EXT;
		GpioDataRegs.GPACLEAR.all = 1;				//clear pull_pin for other EXT
		GpioCtrlRegs.GPADIR.all = 1;
		PULL_PIN = BIT0;
		scia_msg("\r\nREMOVE EXTENSION, PUT MOTOR_EXTENSION AND PRESS ANY KEY\n\0");
	    Wait_For_Any_Key ();
		goto TEST_AGAIN;
	}
	if (Number_Ext == MOTOR)
	{
		if (test_flag == 0) scia_msg("\r\nTEST MOTOR EXTENSION OK!!!\0");		
		Number_Ext = 2;
		GpioDataRegs.GPACLEAR.all = BIT16;				//clear pull_pin for UEXT
		GpioCtrlRegs.GPADIR.all = BIT16;		    	//pull_pin is output
		PULL_PIN = BIT16;
		scia_msg("\r\nREMOVE MOTOR EXTENSION, PUT UEXT AND PRESS ANY KEY\n\0");
	    Wait_For_Any_Key ();
		mask_portA = mask_portA_UEXT;
		mask_portB = mask_portB_UEXT;
		goto TEST_AGAIN;
	}
	if (Number_Ext == UEXT) 
	{
		scia_msg("\r\nTEST UEXT OK\n\0");
		return;
	}
	EDIS;
}


//	simple CAN test
void CAN_Test (void)
{
	scia_msg("\r\n CAN TEST BEGIN\0");	
	EALLOW;
	GpioDataRegs.GPASET.bit.GPIO31 = 1;
	GpioCtrlRegs.GPADIR.bit.GPIO31 = 1;
	DELAY_US(100);
	if (GpioDataRegs.GPADAT.bit.GPIO30 != 0) 
	scia_msg("\r\nCAN Test with 1 OK\0");
	else 
	  {
	     scia_msg("\r\nCAN Test with 1 FAIL\0");
		 Stop();
      }
	GpioDataRegs.GPACLEAR.bit.GPIO31 = 1;
	DELAY_US(100);
	if (GpioDataRegs.GPADAT.bit.GPIO30 == 0) 
	scia_msg("\r\nCAN Test with 0 OK\0");
	else 
	{
	 	scia_msg("\r\n CAN Test with 0 FAIL\0");	
		Stop();
    }
	scia_msg("\r\n REMOVE CAN_E JUMPER AND PRESS ANY KEY\0");	
	Wait_For_Any_Key ();


	GpioDataRegs.GPASET.bit.GPIO31 = 1;
	DELAY_US(100);
	if (GpioDataRegs.GPADAT.bit.GPIO30 != 0) 
	scia_msg("\r\nCAN Test with 1 OK\0");
	else 
	 {
	   scia_msg("\r\nCAN Test with 1 FAIL\0");
	   Stop();
	 }
	GpioDataRegs.GPACLEAR.bit.GPIO31 = 1;
	DELAY_US(100);
	if (GpioDataRegs.GPADAT.bit.GPIO30 != 0) 
	scia_msg("\r\nCAN Test with 0 OK\0");
	else 	
	  {
	    scia_msg("\r\n CAN Test with 0 FAIL\0");		
		Stop();
      }
	EDIS;
}


























