// TI File $Revision: /main/1 $
// Checkin $Date: December 1, 2004   11:11:30 $
//###########################################################################
//
// FILE:	DSP280x_Adc.c
//
// TITLE:	DSP280x ADC Initialization & Support Functions.
//
//###########################################################################
// $TI Release: DSP280x Header Files V1.50 $
// $Release Date: September 10, 2007 $
//###########################################################################

#include "DSP280x_Device.h"     // DSP280x Headerfile Include File
#include "DSP280x_Examples.h"   // DSP280x Examples Include File
#include "pin_test.h"

#define 	ADC_usDELAY  	5000L
#define 	BUF_SIZE   		16  // Sample buffer size
#define		ADC_OFFSET 		40	//-----------------------------------Mnooo losho------------------ 
#define		SHIFT_CONST		4

//---------------------------------------------------------------------------
// InitAdc: 
//---------------------------------------------------------------------------
// This function initializes ADC to a known state.
//
// PLEASE NOTE, ADC INIT IS DIFFERENT ON 281x vs 280x DEVICES!!!
//


void InitAdc(void)
{
    extern void DSP28x_usDelay(Uint32 Count);

    // To powerup the ADC the ADCENCLK bit should be set first to enable
    // clocks, followed by powering up the bandgap, reference circuitry, and ADC core.
    // Before the first conversion is performed a 5ms delay must be observed 
	// after power up to give all analog circuits time to power up and settle

    // Please note that for the delay function below to operate correctly the 
	// CPU_CLOCK_SPEED define statement in the DSP280x_Examples.h file must 
	// contain the correct CPU clock period in nanoseconds. 

	AdcRegs.ADCREFSEL.bit.REF_SEL = 0;		//set reference source

    AdcRegs.ADCTRL3.all = 0x00E0;  // Power up bandgap/reference/ADC circuits
    DELAY_US(ADC_usDELAY);         // Delay before converting ADC channels

	AdcRegs.ADCTRL1.bit.CPS = 1;   //HCLK/2
//    AdcRegs.ADCTRL1.bit.ACQ_PS = 15;  // Sequential mode: Sample rate   = 1/[(2+ACQ_PS)*ADC clock in ns]
					    //                     = 1/(3*80ns) =4.17MHz (for 100 MHz devices or
					    //                     = 1/(3*133ns) = 2.51 MHz (for 60 MHz devices)
					    // If Simultaneous mode enabled: Sample rate = 1/[(3+ACQ_PS)*ADC clock in ns]
   	AdcRegs.ADCTRL1.bit.ACQ_PS = 15;  // Sequential mode: Sample rate   = 1/[(2+ACQ_PS)*ADC clock in ns]
					    //                     = 1/(3*80ns) =4.17MHz (for 100 MHz devices or
					    //                     = 1/(3*133ns) = 2.51 MHz (for 60 MHz devices)
					    // If Simultaneous mode enabled: Sample rate = 1/[(3+ACQ_PS)*ADC clock in ns]


//   AdcRegs.ADCTRL3.bit.ADCCLKPS = ADC_CKPS;

//	AdcRegs.ADCTRL3.bit.SMODE_SEL = 1;

   	AdcRegs.ADCTRL3.bit.ADCCLKPS = 15;		//ADC_clk

    AdcRegs.ADCTRL1.bit.SEQ_CASC = 1;        // 1  Cascaded mode

    AdcRegs.ADCTRL1.bit.CONT_RUN = 1;       // Setup continuous run

    AdcRegs.ADCTRL1.bit.SEQ_OVRD = 1;       // Enable Sequencer override feature
/*
   AdcRegs.ADCCHSELSEQ1.all = 0x7777;         // Initialize all ADC channel selects to B7
   AdcRegs.ADCCHSELSEQ2.all = 0x7777;
   AdcRegs.ADCCHSELSEQ3.all = 0x7777;
   AdcRegs.ADCCHSELSEQ4.all = 0x7777;
*/

    AdcRegs.ADCCHSELSEQ4.bit.CONV15 = 15;
    AdcRegs.ADCCHSELSEQ4.bit.CONV14 = 14;	
    AdcRegs.ADCCHSELSEQ4.bit.CONV13 = 13;
    AdcRegs.ADCCHSELSEQ4.bit.CONV12 = 12; 

    AdcRegs.ADCCHSELSEQ3.bit.CONV11 = 11;
    AdcRegs.ADCCHSELSEQ3.bit.CONV10 = 10;	
    AdcRegs.ADCCHSELSEQ3.bit.CONV09 = 9;
    AdcRegs.ADCCHSELSEQ3.bit.CONV08 = 8;

    AdcRegs.ADCCHSELSEQ2.bit.CONV07 = 7;
    AdcRegs.ADCCHSELSEQ2.bit.CONV06 = 6;	
    AdcRegs.ADCCHSELSEQ2.bit.CONV05 = 5;
    AdcRegs.ADCCHSELSEQ2.bit.CONV04 = 4;

    AdcRegs.ADCCHSELSEQ1.bit.CONV03 = 3;
    AdcRegs.ADCCHSELSEQ1.bit.CONV02 = 2;	
    AdcRegs.ADCCHSELSEQ1.bit.CONV01 = 1;
    AdcRegs.ADCCHSELSEQ1.bit.CONV00 = 0;

    AdcRegs.ADCMAXCONV.bit.MAX_CONV1 = 0xf;  // convert and store in 8 results registers   

	AdcRegs.ADCOFFTRIM.all = 0;
//	AdcRegs.ADCOFFTRIM.all = -35;

	AdcRegs.ADCTRL2.all = 0x2000;   

}	
/*
void TestAdc(void)
{	
Uint16 AdcSampleTable[BUF_SIZE];
unsigned int ADC_Result, ADC_result_High, ADC_result_Low;
unsigned char i; 
	
// Start SEQ1
     AdcRegs.ADCTRL2.all = 0x2000;

	 scia_msg("\r\nREMOVE UEXT, PUT ANALOG EXT and PRESS ANY KEY\0");
     Wait_For_Any_Key ();

     while (AdcRegs.ADCST.bit.INT_SEQ1== 0){}	   

     AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;

	 AdcSampleTable[0] = AdcRegs.ADCRESULT0>>SHIFT_CONST;
	 AdcSampleTable[1] = AdcRegs.ADCRESULT1>>SHIFT_CONST;
	 AdcSampleTable[2] = AdcRegs.ADCRESULT2>>SHIFT_CONST;
	 AdcSampleTable[3] = AdcRegs.ADCRESULT3>>SHIFT_CONST;
	 AdcSampleTable[4] = AdcRegs.ADCRESULT4>>SHIFT_CONST;
	 AdcSampleTable[5] = AdcRegs.ADCRESULT5>>SHIFT_CONST;
	 AdcSampleTable[6] = AdcRegs.ADCRESULT6>>SHIFT_CONST;
	 AdcSampleTable[7] = AdcRegs.ADCRESULT7>>SHIFT_CONST;
	 AdcSampleTable[8] = AdcRegs.ADCRESULT8>>SHIFT_CONST;
	 AdcSampleTable[9] = AdcRegs.ADCRESULT9>>SHIFT_CONST;
	 AdcSampleTable[10] = AdcRegs.ADCRESULT10>>SHIFT_CONST;
	 AdcSampleTable[11] = AdcRegs.ADCRESULT11>>SHIFT_CONST;
	 AdcSampleTable[12] = AdcRegs.ADCRESULT12>>SHIFT_CONST;
	 AdcSampleTable[13] = AdcRegs.ADCRESULT13>>SHIFT_CONST;
	 AdcSampleTable[14] = AdcRegs.ADCRESULT14>>SHIFT_CONST;
	 AdcSampleTable[15] = AdcRegs.ADCRESULT15>>SHIFT_CONST;

	 ADC_Result = AdcRegs.ADCRESULT15>>SHIFT_CONST;

	 ADC_Result = (AdcSampleTable[14] / 15);

	 for (i=0;i<15;i++)
	 {
		ADC_result_High = ADC_Result*(i+1)+ADC_OFFSET;
		ADC_result_Low = ADC_Result*(i+1)-ADC_OFFSET;
	 	if ((AdcSampleTable[i] > ADC_result_High ) 
	 	 || (AdcSampleTable[i] < ADC_result_Low)) 
	 	{
			if (i<8)
			{
	 			scia_msg("\r\nERROR-ADCINA\0");
				scia_xmit('0'+i);
			}
			if (i>7)
			{
				scia_msg("\r\nERROR-ADCINB\0");
				scia_xmit('0'+(i-8));
			}
		}
		else 
		{
			if (i<8)
			{
	 			scia_msg("\r\nOK-ADCINA\0");
				scia_xmit('0'+i);
			}
			if (i>7)
			{
				scia_msg("\r\nOK-ADCINB\0");
				scia_xmit('0'+(i-8));
			}
		}
	 }
}
*/


//===========================================================================
// End of file.
//===========================================================================
