#include "avr_compiler.h"
#include "adc_driver.h"

#define HIGH_OPTIMATION

/*! How many samples for each ADC channel.*/
#define SAMPLE_COUNT 10

/*! Sample storage (all four channels).*/
uint16_t adcSamples[4][SAMPLE_COUNT];

int main(void)
{
  	uint8_t offset;

	/* Move stored calibration values to ADC B. */
	ADC_CalibrationValues_Set(&ADCB);

	/* Get offset value for ADC A. */
 	offset = ADC_Offset_Get(&ADCB);

	/* Set up ADC B to have signed conversion mode and 12 bit resolution. */
  	ADC_ConvMode_and_Resolution_Config(&ADCB, false, ADC_RESOLUTION_12BIT_gc);

	/* Sample rate is CPUFREQ/8. Allow time for storing data. */
	ADC_Prescaler_Config(&ADCB, ADC_PRESCALER_DIV8_gc);

	/* Set referance voltage on ADC B to be VCC-0.6 V.*/
	ADC_Referance_Config(&ADCB, ADC_REFSEL_VCC_gc);

	/* Setup channel 0 to have single ended input. */
	ADC_Ch_InputMode_and_Gain_Config(&ADCB.CH0,
	                                 ADC_CH_INPUTMODE_SINGLEENDED_gc,
	                                 ADC_CH_GAIN_1X_gc);

	//ADC_Ch_InputMode_and_Gain_Config(&ADCA.CH1,
	//                                 ADC_CH_INPUTMODE_SINGLEENDED_gc,
	//                                 ADC_CH_GAIN_1X_gc);

	//ADC_Ch_InputMode_and_Gain_Config(&ADCA.CH2,
	//                                 ADC_CH_INPUTMODE_SINGLEENDED_gc,
        //                                 ADC_CH_GAIN_1X_gc);

	//ADC_Ch_InputMode_and_Gain_Config(&ADCA.CH3,
	//                                 ADC_CH_INPUTMODE_SINGLEENDED_gc,
	//                                 ADC_CH_GAIN_1X_gc);

	/* Set input to the channel in ADC B to be PIN 1. */
	ADC_Ch_InputMux_Config(&ADCB.CH0, ADC_CH_MUXPOS_PIN1_gc, ADC_CH_MUXNEG_PIN0_gc);
	//ADC_Ch_InputMux_Config(&ADCA.CH1, ADC_CH_MUXPOS_PIN5_gc, ADC_CH_MUXNEG_PIN0_gc);
	//ADC_Ch_InputMux_Config(&ADCA.CH2, ADC_CH_MUXPOS_PIN6_gc, ADC_CH_MUXNEG_PIN0_gc);
	//ADC_Ch_InputMux_Config(&ADCA.CH3, ADC_CH_MUXPOS_PIN7_gc, ADC_CH_MUXNEG_PIN0_gc);

	/* Setup sweep of all four virtual channels. */
	ADC_SweepChannels_Config(&ADCB, ADC_SWEEP_0_gc);

	/* Enable ADC B with free running mode, Vcc reference and unsigned conversion.*/
	ADC_Enable(&ADCB);

	/* Wait until common mode voltage is stable. Default clk is 2MHz and
	 * therefore below the maximum frequency to use this function. */
	ADC_Wait_8MHz(&ADCB);

	/* Enable free running mode. */
	ADC_FreeRunning_Enable(&ADCB);

	/* Store samples in table.*/
	for (uint16_t i = 0; i < SAMPLE_COUNT; ++i) {

	  	do{
			/* If the conversion on the ADCA channel 0 never is
			 * complete this will be a deadlock. */
		}while(!ADC_Ch_Conversion_Complete(&ADCB.CH0));
		adcSamples[0][i] = ADC_ResultCh_GetWord(&ADCB.CH0, offset);
	}

	/* Turn off free running and disable ADC module.*/
	ADC_FreeRunning_Disable(&ADCB);
	ADC_Disable(&ADCB);

	/* Infinite loop.*/
	while (true){
	}
}





