#include "usart_driver.h"
#include "avr_compiler.h"


// Define that selects the Usart used in example.  
#define USART USARTC0


// Success variable, used to test driver.  
bool success;


/*  Example application.
 *
 *  Example applicaton. This example configures USARTC0 for with the parameters:
 *      - 8 bit character size
 *      - No parity
 *      - 1 stop bit
 *      - 9600 Baud
 *
 *  This function then sends the values 0-255 and tests if the received data is
 *  equal to the sent data. The code can be tested by connecting PC3 to PC2. If
 *  the variable 'success' is true at the end of the function, the values
 *  have been successfully sent and received.
 */
int main(void)
{

	// Variable used to send and receive data.  
	uint8_t sendData;
	uint8_t receivedData;

	// This PORT setting is only valid to USARTC0 if other USARTs is used a
	// different PORT and/or pins is used. 
	// PIN3 (TXD0) as output.  
	PORTC.DIRSET = PIN3_bm;

	// PC2 (RXD0) as input.  
	PORTC.DIRCLR = PIN2_bm;

	// USARTC0, 8 Data bits, No Parity, 1 Stop bit. 
	USART_Format_Set(&USART, USART_CHSIZE_8BIT_gc, USART_PMODE_DISABLED_gc, false);

	/* Set Baudrate to 9600 bps:
	 * Use the default I/O clock fequency that is 2 MHz.
	 * Do not use the baudrate scale factor
	 *
	 * Baudrate select = (1/(16*(((I/O clock frequency)/Baudrate)-1)
	 *                 = 12
	 */
	USART_Baudrate_Set(&USART, 12 , 0);

	// Enable both RX and TX. 
	USART_Rx_Enable(&USART);
	USART_Tx_Enable(&USART);


	// Assume that everything is OK.  
	success = true;
	// Send data from 255 down to 0 
	sendData = 255;
	while(sendData) {
	    // Send one char.  
		do{
		// Wait until it is possible to put data into TX data register.
		// NOTE: If TXDataRegister never becomes empty this will be a DEADLOCK. 
		}while(!USART_IsTXDataRegisterEmpty(&USART));
		USART_PutChar(&USART, sendData);

		uint16_t timeout = 1000;
		// Receive one char. 
		do{
		// Wait until data received or a timeout.
		timeout--;
		}while(!USART_IsRXComplete(&USART) && timeout!=0);
		receivedData = USART_GetChar(&USART);

		// Check the received data.  
		if (receivedData != sendData){
			success = false;
		}
		sendData--;
	}

	// Disable both RX and TX.  
	USART_Rx_Disable(&USART);
	USART_Tx_Disable(&USART);

	// If success the program ends up inside the if statment. 
	if(success){
		while(true);
	}else{
	  	while(true);
	}
}
