/********************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
 /* ******************************************************************************
  * @file    Project/STM32F4xx_StdPeriph_Template/main.c 
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    13/06/2011
  * @brief   Main program body
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2010 STMicroelectronics</center></h2>
  */ 

/* Includes ------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <yfuns.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdbool.h>
#include <limits.h>
#include <intrinsics.h>
#include <assert.h>
#include <math.h>
#include <stdint.h>

#include "stm32f4xx.h"
#include "stm32f4xx_conf.h"
#include "stm32f4xx_gpio.h"

#include "usbd_hid_core.h"
#include "usbd_usr.h"
#include "usbd_desc.h"
    
#include "Custom.h"
#include "Test/USB_Mouse/USB_Mouse.h"
#include "Test/LEDs_Button/LEDs_Button.h"
#include "Test/RTC/RTC.h"


/** @addtogroup Template_Project
  * @{
  */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/


void USART_Initialize (void)
{
  USART_InitTypeDef USART_InitStructure;
  USART_InitStructure.USART_BaudRate = 115200;
  USART_InitStructure.USART_WordLength = USART_WordLength_8b;
  USART_InitStructure.USART_StopBits = USART_StopBits_1;
  USART_InitStructure.USART_Parity = USART_Parity_No;
  USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
  USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;
  STM_EVAL_COMInit(COM1, &USART_InitStructure);
}

void Demo_Routine ()
{
  RTC_TimeTypeDef  RTC_TimeStructure;
  int Prev_RTC_Seconds=0;
  char Buff[16];
  RTC_Initialize ();
  USART_Write_String ("\fLED will blink with 1Hz frequnecy (RTC)\n\r");
  USART_Write_String ("On the terminal elapsed time will be printed\n\r");
  USART_Write_String ("Push the button to spin the mouse cursor\n\r");
  while (1)
  {
    RTC_GetTime(RTC_Format_BIN, &RTC_TimeStructure);
    // RTC & LED
    if (RTC_TimeStructure.RTC_Seconds != Prev_RTC_Seconds)
    {
      LED_Toggle ();
      Prev_RTC_Seconds = RTC_TimeStructure.RTC_Seconds;
      sprintf((char*)Buff,"%0.2d:%0.2d:%0.2d\r", RTC_TimeStructure.RTC_Hours, RTC_TimeStructure.RTC_Minutes, RTC_TimeStructure.RTC_Seconds);
      USART_Write_String (Buff);
    }
    // USB & Button
    if (Button_Pressed())
      for (int i=0; i<4; i++)
        USB_Mouse (i, MOUSE_DELTA);
  }
}

/*******************************************************************************
* Function Name  : main.
* Description    : main routine.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/

int main (void)
{
  LEDs_Button_Init ();
  USBD_Init(&USB_OTG_dev, USB_OTG_FS_CORE_ID, &USR_desc, &USBD_HID_cb, &USR_cb);
  USART_Initialize ();
  Demo_Routine ();
  return 0;
}


/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/

