#ifndef _CUSTOM_H_
#define _CUSTOM_H_

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define USED_UART       2

#if (USED_UART==1)
  #define CHOSEN_COM      COM1
  #define CHOSEN_EVAL_COM EVAL_COM1
#elif  (USED_UART==2)
  #define CHOSEN_COM      COM2
  #define CHOSEN_EVAL_COM EVAL_COM2
#endif
/* Private macro -------------------------------------------------------------*/
/* Extern variables ----------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

/*******************************************************************************
* Function Name  : USART_Write_Char.
* Description    : send a sungle character to USART.
* Input          : character to be printed.
* Return         : none.
*******************************************************************************/
void USART_Write_Char (char c);

/*******************************************************************************
* Function Name  : USART_Write_String.
* Description    : send a string to USART.
* Input          : String to be printed.
* Return         : none.
*******************************************************************************/
void USART_Write_String (char Str[]);

/*******************************************************************************
* Function Name  : USART_Read_Char.
* Description    : reads the last input from the USART.
* Input          : None.
* Return         : last input character from the terminal.
*******************************************************************************/
char USART_Read_Char ();

void Delay (volatile unsigned long Time);

void Wait_for_Enter ();

void Wait_for_Space ();

void Wait_for_Escape ();

#endif
