#include "stm32f4xx_usart.h"
#include "Custom.h"


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Extern variables ----------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : USART_Write_Char.
* Description    : send a single character to USART.
* Input          : character to be printed.
* Return         : none.
*******************************************************************************/
void USART_Write_Char (char c)
{
  USART_SendData (USART2, c);
  while (!USART_GetFlagStatus (USART2, USART_FLAG_TXE));
}

/*******************************************************************************
* Function Name  : USART_Write_String.
* Description    : send a string to USART.
* Input          : String to be printed.
* Return         : none.
*******************************************************************************/
void USART_Write_String (char Str[])
{
  int i;
  for (i=0; Str[i]; i++)
    USART_Write_Char (Str[i]);
}

/*******************************************************************************
* Function Name  : USART_Read_Char.
* Description    : reads the last input from the USART.
* Input          : None.
* Return         : a character input from terminal or 0 if none.
*******************************************************************************/
char USART_Read_Char ()
{
  if (USART_GetFlagStatus (USART2, USART_FLAG_RXNE))
    return USART_ReceiveData (USART2);
  else
    return 0;
}

void Delay (volatile unsigned long Time)
{
  while (Time--)
    for (volatile int i=6000; i; i--);
}

void Wait_for_Enter ()
{
  USART_Write_String ("Натиснете ENTER за продължаване\n\r");
  while (USART_Read_Char() != 0xa);      // enter
}

void Wait_for_Space ()
{
  USART_Write_String ("Натиснете SPACE за продължаване\n\r");
  while (USART_Read_Char() != 0x20);      // space
}

void Wait_for_Escape ()
{
  USART_Write_String ("Натиснете ESC за продължаване\n\r");
  while (USART_Read_Char() != 0x1b);      // escape
}
