#include "USB_Mouse.h"
#include "..\LEDs_Button\LEDs_Button.h"
#include "Custom.h"

__ALIGN_BEGIN USB_OTG_CORE_HANDLE  USB_OTG_dev __ALIGN_END;

void USB_Mouse(int Direction, int Steps)
{
  unsigned char buf[4] = {0, 0, 0, 0};
  switch (Direction)
  {
  case 0:
    X += Steps;
    break;
  case 1:
    Y += Steps;
    break;
  case 2:
    X -= Steps;
    break;
  case 3:
    Y -= Steps;
    break;
  default:
    break;
  }

  USBD_HID_SendReport (&USB_OTG_dev, buf, 4);
  Delay (20);
  return;
}

void USB_Test ()
{
  //USBD_Init(&USB_OTG_dev, USB_OTG_FS_CORE_ID, &USR_desc, &USBD_HID_cb, &USR_cb);
  USART_Write_String ("Натиснете бутона, за да започне да се върти курсора на мишката\n\r");
  USART_Write_String ("Натиснете ESC за прекратяване\n\r");
  while (USART_Read_Char () != 0x1b)
  {
    if (Button_Pressed())
      for (int i=0; i<4; i++)
        USB_Mouse (i, MOUSE_DELTA);
  }
}
