#include "stm32f4xx.h"
#include "Custom.h"
#include "RTC.h"
#include <stdio.h>

/**
  * @brief  Configures the RTC.
  * @param  None
  * @retval None
  */
void RTC_Initialize(void)
{
  RTC_TimeTypeDef  RTC_TimeStructure;
  RTC_InitTypeDef  RTC_InitStructure;

  __IO uint32_t uwAsynchPrediv = 0;
  __IO uint32_t uwSynchPrediv = 0;
  
  /* Enable the PWR clock */
  //RCC_APB1PeriphClockCmd(RCC_APB1Periph_PWR, ENABLE);

  /* Allow access to RTC */
  PWR_BackupAccessCmd(ENABLE);
    
  /* Enable the LSE OSC */
  RCC_LSEConfig(RCC_LSE_ON);

  /* Wait till LSE is ready */  
  while(RCC_GetFlagStatus(RCC_FLAG_LSERDY) == RESET);

  /* Select the RTC Clock Source */
  RCC_RTCCLKConfig(RCC_RTCCLKSource_LSE);
  /* ck_spre(1Hz) = RTCCLK(LSE) /(uwAsynchPrediv + 1)*(uwSynchPrediv + 1)*/
  uwSynchPrediv = 0xFF;
  uwAsynchPrediv = 0x7F;
  
  /* Enable the RTC Clock */
  RCC_RTCCLKCmd(ENABLE);

  /* Wait for RTC APB registers synchronisation */
  RTC_WaitForSynchro();
  
  /* Configure the RTC data register and RTC prescaler */
  RTC_InitStructure.RTC_AsynchPrediv = uwAsynchPrediv;
  RTC_InitStructure.RTC_SynchPrediv = uwSynchPrediv;
  RTC_InitStructure.RTC_HourFormat = RTC_HourFormat_24;
  RTC_Init(&RTC_InitStructure);
  
  /* Set the time to 00h 00mn 00s AM */
  RTC_TimeStructure.RTC_H12     = RTC_H12_AM;
  RTC_TimeStructure.RTC_Hours   = 0x00;
  RTC_TimeStructure.RTC_Minutes = 0x00;
  RTC_TimeStructure.RTC_Seconds = 0x00; 
  
  RTC_SetTime(RTC_Format_BCD, &RTC_TimeStructure);
  
  /* Indicator for the RTC configuration */
  //RTC_WriteBackupRegister(RTC_BKP_DR0, 0x32F2);
}

void RTC_Test ()
{
  RTC_TimeTypeDef  RTC_TimeStructure;
  int Prev_RTC_Seconds=0;
  char Buff[16];
  USART_Write_String ("Натиснете ESC за прекъсване на теста\n\r");
  RTC_Initialize ();
  while (USART_Read_Char () != 0x1b)
  {
    RTC_GetTime(RTC_Format_BIN, &RTC_TimeStructure);
    if (RTC_TimeStructure.RTC_Seconds != Prev_RTC_Seconds)
    {
      Prev_RTC_Seconds = RTC_TimeStructure.RTC_Seconds;
      sprintf((char*)Buff,"%0.2d:%0.2d:%0.2d\r",RTC_TimeStructure.RTC_Hours, RTC_TimeStructure.RTC_Minutes, RTC_TimeStructure.RTC_Seconds);
      USART_Write_String (Buff);
    }
  }
}
