#include "Custom.h"
#include "LEDs_Button.h"
#include "stm32f4xx.h"

static GPIO_InitTypeDef GPIO_InitStructure;

void LEDs_Button_Init ()
{
  // Green LED Periph clock enable
  RCC_AHB1PeriphClockCmd(LED_PERIPH, ENABLE);
  GPIO_InitStructure.GPIO_Pin = LED_PIN;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(LED_GPIO, &GPIO_InitStructure);
  LED_Off ();
  
  // Button Periph clock enable
  RCC_AHB1PeriphClockCmd(BUTTON_PERIPH, ENABLE);
  GPIO_InitStructure.GPIO_Pin = BUTTON_LED_PIN;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(BUTTON_LED_GPIO, &GPIO_InitStructure);
}

void LED_SetState (int State)
{
  if (State)
    LED_GPIO->ODR &= (~LED_PIN);
  else
    LED_GPIO->ODR |= LED_PIN;
}

int LED_GetState ()
{
  if (LED_GPIO->IDR & LED_PIN)
    return 1;
  else
    return 0;
}

void LED_On ()
{
  LED_SetState (1);
}

void LED_Off ()
{
  LED_SetState (0);
}

void LED_Toggle ()
{
  LED_GPIO->ODR = LED_GPIO->ODR ^ LED_PIN;
}

int Button_State ()
{
  if (BUTTON_LED_GPIO->IDR & BUTTON_LED_PIN)
    return 0;
  else
    return 1;
}

int Button_Pressed ()
{
  return (Button_State () == 1);
}

int Button_Released ()
{
  return (Button_State () == 0);
}

void StartUp_Blink ()
{
  LEDs_Button_Init ();
  for (int i=10; i; i--)
  {
    LED_Toggle ();
    Delay (50);
  }
  LED_Off ();
}
