/*************************************************************************
 *
 *    Used with ICCARM and AARM.
 *
 *    (c) Copyright IAR Systems 2008
 *
 *    File name   : accl_drv.h
 *    Description : Accelerometer sensor LIS3L020 driver include file
 *
 *    History :
 *    1. Date        : July 24, 2008
 *       Author      : Stanimir Bonev
 *       Description : Create
 *
 *    $Revision: 48478 $
 **************************************************************************/
#include "includes.h"

#ifndef __ACCL_DRV_H
#define __ACCL_DRV_H

#ifdef  ACCL_DRV_GLOBAL
#define ACCL_DRV_EXTERN
#else
#define ACCL_DRV_EXTERN  extern
#endif

#define ACC_SENSOR_ADDR     (0x18<<1) // SPP_I2C

typedef enum _Accl_regs_t
{
  WHO_AM_I = 0x00,
  OFFSET_X = 0x16, OFFSET_Y, OFFSET_Z, GAIN_X, GAIN_Y, GAIN_Z,
  CTRL_REG1 = 0x20, CTRL_REG2, CTRL_REG3, HP_FILTER_RESET,
  STATUS_REG = 0x27, OUTX_L, OUTX_H, OUTY_L, OUTY_H, OUTZ_L, OUTZ_H,
  FF_WU_CFG = 0x30, FF_WU_SRC, FF_WU_ACK,
  FF_WU_THS_L = 0x34, FF_WU_THS_H, FF_WU_DURATION,
  DD_CFG = 0x38, DD_SRC, DD_ACK,
  DD_THSI_L = 0x3C, DD_THSI_H, DD_THSE_L, DD_THSE_H
} Accl_regs_t;

/*************************************************************************
 * Function Name: Accl_Init
 * Parameters: none
 *
 * Return: Boolean
 *
 * Description: Init Accelerometer sensor
 *
 *************************************************************************/
Boolean Accl_Init (void);

/*************************************************************************
 * Function Name: Accl_Get
 * Parameters: pInt16S pX, pInt16S pY, pInt16S pZ
 *
 * Return: Boolean
 *
 * Description: Read X,Y,Z data
 *
 *************************************************************************/
Boolean Accl_Get (pInt16S pX, pInt16S pY, pInt16S pZ, pInt8S pT);

#endif // __ACCL_DRV_H