/*************************************************************************
 *
 *    Used with ICCARM and AARM.
 *
 *    (c) Copyright IAR Systems 2008
 *
 *    File name   : accl_drv.c
 *    Description : Accelerometer sensor LIS3L020 driver source file
 *
 *    History :
 *    1. Date        : July 24, 2008
 *       Author      : Stanimir Bonev
 *       Description : Create
 *
 *    $Revision: 48478 $
 **************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "accl_drv.h"
#include "i2c1_drv.h"
/* Private typedef -----------------------------------------------------------*/

/* Private define ------------------------------------------------------------*/
#define ACCL_DRV_GLOBAL
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

// SPP +

Boolean Accl_Write (unsigned char Register, unsigned char Data)
{
  unsigned char Buff[2] = {Register, Data};

  if(FALSE == I2C1_DataTransfer(ACC_SENSOR_ADDR, Buff, 2))
  {
    I2C1_Close();
    return(FALSE);
  }
  return TRUE;
}

Boolean Accl_Read (unsigned char Register, unsigned char *Data, int size)
{
  unsigned char Buff[1] = {Register};

  if(FALSE == I2C1_DataTransfer(ACC_SENSOR_ADDR, Buff, 1))
  {
    I2C1_Close();
    return(FALSE);
  }

  if(FALSE == I2C1_DataTransfer(ACC_SENSOR_ADDR | 1, Data, size))
  {
    I2C1_Close();
    return(FALSE);
  }
  return TRUE;
}
// SPP -

/*******************************************************************************
* Function Name  : Accl_Init
* Description    : Init Accelerometer sensor
* Input          : None
* Output         : None
* Return         : Boolean.
*******************************************************************************/

Boolean Accl_Init (void)
{
GPIO_InitTypeDef GPIO_InitStructure;
u8 Data[2];

  // Enable GPIOB port
  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE);
  RCC_AHB1PeriphResetCmd(RCC_AHB1Periph_GPIOB, DISABLE);

  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;  // SPP
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  if(FALSE == I2C1_Open())
    return(FALSE);
  
  Accl_Read (WHO_AM_I, Data, 1);
  if(0x03 != Data[0]) // SPP_I2C
  {
    I2C1_Close();
    return(FALSE);
  }

  I2C1_Close();
  return(TRUE);
}

/*************************************************************************
 * Function Name: Accl_Get
 * Parameters: pInt16S pX, pInt16S pY, pInt16S pZ, pInt8S pT
 *
 * Return: Boolean
 *
 * Description: Read X,Y,Z, T data
 *
 *************************************************************************/
Boolean Accl_Get (pInt16S pX, pInt16S pY, pInt16S pZ, pInt8S pT)
{
  if(FALSE == I2C1_Open())
    return(FALSE);

  u8 Data[7];
  {
    Accl_Read (0x02, Data, 7); 
    if (Data[0] & 0x01)
      *pX = (u16) (Data[1] << 2) | (Data[0] >> 6);
    if (Data[2] & 0x01)
      *pY = (u16) (Data[3] << 2) | (Data[2] >> 6);
    if (Data[4] & 0x01)
      *pZ = (u16) (Data[5] << 2) | (Data[4] >> 6);
    *pT = Data[6];
  }
    
  I2C1_Close();

  return(TRUE);
}

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
