#include "test.h"
#include "mmc.h"
#include "stm32f4xx_gpio.h"
#include <string.h>
#include "bits.h"

// mmc variable
extern char mmc_buffer[512];
char mmc_buffer_test_1[512];
char state_mmc = 1;

// ext variable
char state_ext = 1;
char i=0;

static GPIO_InitTypeDef GPIO_InitStructure;

void DelayN (unsigned long a) { while (--a!=0); }

unsigned char CardIsPresent(void)
{
  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE);

  // CP
  GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_12;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  if((GPIO_ReadInputDataBit(GPIOB, GPIO_Pin_12)) == Bit_SET)
    return 0; // Card present
  else
    return 1;
}

// MMC ======================================================================================
unsigned char DemoMMC(void)
{

  // return value - 0 - mmc error
  // return value - 1 - mmc test ok
  // return value - 2 - mmc card not present

  // set success
  state_mmc = 1;

  
  // Enable clock
  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE);
  
  // CP
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_12;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  for (volatile int i=1000000; i; i--);
  if((GPIO_ReadInputDataBit(GPIOB, GPIO_Pin_12)) != Bit_SET)
    return 2; // Card not present

  if (initMMC() == MMC_SUCCESS)	// card found
  {
    //card_state |= 1;
    memset(&mmc_buffer,0,512);
    mmcReadRegister (10, 16);
    mmc_buffer[7]=0;

    // Fill first Block (0) with 'A'
    memset(&mmc_buffer,'0',512);    //set breakpoint and trace mmc_buffer contents
    mmcWriteBlock(0);
    // Fill second Block (1)-AbsAddr 512 with 'B'
    memset(&mmc_buffer,'1',512);
    mmcWriteBlock(512);

    // Read first Block back to buffer
    memset(&mmc_buffer,0x00,512);
    mmcReadBlock(0,512);
    memset(&mmc_buffer_test_1,'0',512);
    if(strncmp(&mmc_buffer[0], &mmc_buffer_test_1[0], 512))
      state_mmc=0;

    // Read first Block back to buffer
    memset(&mmc_buffer,0x00,512);
    mmcReadBlock(512,512);
    memset(&mmc_buffer_test_1,'1',512);
    if(strncmp(&mmc_buffer[0], &mmc_buffer_test_1[0], 512))
      state_mmc=0;

    memset(&mmc_buffer,0x00,512);
  }

  return state_mmc;
}
