/********************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
 /* ******************************************************************************
  * @file    Project/STM32F4xx_StdPeriph_Template/main.c 
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    13/06/2011
  * @brief   Main program body
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2010 STMicroelectronics</center></h2>
  */ 

/* Includes ------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <yfuns.h>
#include "includes.h"

#include "stm32f4xx_gpio.h"
#include "arm_comm.h"
#include "lcd.h"
#include "includes.h"
#include "adc.h"
#include "pwm.h"
#include "bits.h"
#include "mmc.h"
#include "test.h"
#include "rtc.h"
#include "const.h"
#include "i2c.h"

#include  "usbd_hid_core.h"
#include  "usbd_usr.h"
#include  "usbd_desc.h"

#define MENU_NUMB   5

unsigned char Inversion[] = { 0, 0, 0, 0, 0, 0, 0, 0 };

unsigned char Menu[MENU_NUMB][15] = {
 " Demo MMC Card\0",
 " Demo Audio   \0",
 " Demo RTC     \0",
 " Demo Acceler.\0",
 " Demo USB     \0",
  //"             \0",
  //"             \0",
  //"www.olimex.com\0"
};

#define KEY_NONE    0
#define KEY_UP      1
#define KEY_DOWN    2
#define KEY_LEFT    3
#define KEY_RIGHT   4
#define KEY_CENTER  5
#define KEY_UL      6
#define KEY_UR      7
#define KEY_DL      8
#define KEY_DR      9

#define UP_VALUE      1024
#define DOWN_VALUE    256
#define LEFT_VALUE    2050
#define RIGHT_VALUE   530
#define UL_VALUE      2340
#define UR_VALUE      1327
#define DL_VALUE      2115
#define DR_VALUE      722
#define DIVERSION     30

#define DLY_100US  1000

unsigned char ch=0, index=0, but1_flag=0, but2_flag=0, offset, menu_flag=0;
unsigned char config, status_temp, payload;
extern unsigned char status;
static GPIO_InitTypeDef GPIO_InitStructure;
I2C_InitTypeDef I2C_InitStructure;
signed char new_pos=0, cur_pos=-1;
volatile unsigned int dly;
unsigned char JoyPos;
unsigned char MenuPos;
Int16U ADCValue;
unsigned char jjj=0;
unsigned char test_state=0;


void Delay_ (unsigned long a) { while (--a!=0); }


Int32U CriticalSecCntr;
/** @addtogroup Template_Project
  * @{
  */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
//static int MyLowLevelGetchar(void);
//size_t __write(int Handle, const unsigned char * Buf, size_t Bufsize);
//size_t __read(int handle, unsigned char * buffer, size_t size);
void Joystick_Init (void);

/* Private functions ---------------------------------------------------------*/
/*************************************************************************
 * Function Name: InitJoystick
 * Parameters: none
 * Return: none
 *
 * Description: Init joystick position
 *
 *************************************************************************/
void InitJoystick(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  // Set variables asociates
  JoyPos = 0;
  MenuPos = 1;

  // Init
  ADCInit();

  // BUTTON CENTER as input
  GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_6;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOC, &GPIO_InitStructure);

  // B1 as input
  GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_13;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOC, &GPIO_InitStructure);
}


/*************************************************************************
 * Function Name: GetJoystickPosition
 * Parameters: none
 * Return: Joistick position
 *
 * Description: Measure ADC and return joystick position
 *
 *************************************************************************/
unsigned char GetJoystickPosition (void) {

  ADCValue = GetADCChanel(ADC_Channel_15);

  if( (ADCValue>(UP_VALUE-DIVERSION))&&(ADCValue<(UP_VALUE+DIVERSION)) )       { return KEY_UP; }
  if( (ADCValue>(DOWN_VALUE-DIVERSION))&&(ADCValue<(DOWN_VALUE+DIVERSION)) )   { return KEY_DOWN; }
  if( (ADCValue>(LEFT_VALUE-DIVERSION))&&(ADCValue<(LEFT_VALUE+DIVERSION)) )   { return KEY_LEFT; }
  if( (ADCValue>(RIGHT_VALUE-DIVERSION))&&(ADCValue<(RIGHT_VALUE+DIVERSION)) ) { return KEY_RIGHT; }
  
  if( (ADCValue>(UL_VALUE-DIVERSION))&&(ADCValue<(UL_VALUE+DIVERSION)) ) { return KEY_UL; }
  if( (ADCValue>(UR_VALUE-DIVERSION))&&(ADCValue<(UR_VALUE+DIVERSION)) ) { return KEY_UR; }
  if( (ADCValue>(DL_VALUE-DIVERSION))&&(ADCValue<(DL_VALUE+DIVERSION)) ) { return KEY_DL; }
  if( (ADCValue>(DR_VALUE-DIVERSION))&&(ADCValue<(DR_VALUE+DIVERSION)) ) { return KEY_DR; }

  if((GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_6)) == Bit_SET) return KEY_CENTER;

  return KEY_NONE;

}

/*************************************************************************
 * Function Name: UpdateMenu
 * Parameters: Position of menue
 * Return: None
 *
 * Description: Black mark of menu position
 *
 *************************************************************************/
void UpdateMenu(unsigned char pos) {
  int i;
  Inversion[pos-1] = 1;

  if(menu_flag==0)
  {
    if(pos==9) { offset=3; menu_flag=1; }
    if(pos==8) { offset=2; menu_flag=1; }
    if(pos==7) { offset=1; }
    if(pos==1) { offset=0; }
  }
  else
  {
    if(pos==9) { offset=3; }
    if(pos==8) { offset=2; }
    if(pos==7) { offset=1; }
    if(pos==1) { offset=0;  menu_flag=0; }
  }


  LCDClear();
  for (i=0; i<MENU_NUMB; i++)
    LCDStr (i, Menu[i+offset], Inversion[i+offset]);
  LCDUpdate();

  Inversion[pos-1] = 0;
}


char buff_x[10];
char buff_y[10];
char buff_z[10];

unsigned char value_h;
unsigned char value_l;
unsigned int  value;
unsigned char val;

// SPP +
/*******************************************************************************
* Function Name  : Accelerometer_Demo
* Description    : Accelerometer_Demo program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Accelerometer_Demo(void)
{
  s16 X, Y, Z;
  s8 T;
  u32 Timeout=0;
  unsigned char XStr[16], YStr[16], ZStr[16], TStr[16];
  
  /*I2C1 init*/
  I2C1_Init();

  /* Init Accl sensor*/
  if(FALSE == Accl_Init())
  {
    /* Initialization fault*/
    GLCD_TextSetPos(0,0);
    GLCD_print("\fBMA250 Init.\r\nfault\r\n");
    while(1);
  }
  while (!STM_EVAL_PBGetState (BUTTON_TAMPER))
  {
    if (Timeout--)
      continue;
    Timeout = 1000000;
    /* Get new sample of the axes*/
    if(Accl_Get(&X,&Y,&Z,&T))
    {
      if (X>=512)
        X = X - 1024;
      
      if (Y>=512)
        Y = Y - 1024;
      
      if (Z>=512)
        Z = Z - 1024;
      
      T = (T>>1) + 24;
      sprintf ((char*) XStr, "   X = %d", X);
      sprintf ((char*) YStr, "   Y = %d", Y);
      sprintf ((char*) ZStr, "   Z = %d", Z);
      sprintf ((char*) TStr, "   T = %d C", T);

      LCDClear();
      LCDStr ( 0, "  Accel Demo  ", 0 );
      LCDStr ( 1, XStr, 0 );
      LCDStr ( 2, YStr, 0 );
      LCDStr ( 3, ZStr, 0 );
      LCDStr ( 4, TStr, 0 );
      LCDStr ( 5, "End", 0 );
      LCDUpdate();
    }
  }

  while (STM_EVAL_PBGetState (BUTTON_TAMPER));
}

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
// SPP -

/*-------------SysTickStart---------------------------------------------------*/
void SysTickStart(uint32_t Tick)
{
RCC_ClocksTypeDef Clocks;
volatile uint32_t dummy;

  RCC_GetClocksFreq(&Clocks);

  dummy = SysTick->CTRL;  
  SysTick->LOAD = (Clocks.HCLK_Frequency/8)/Tick;
  
  SysTick->CTRL = 1;
}
/*-------------SysTickStop----------------------------------------------------*/
void SysTickStop(void)
{
    SysTick->CTRL = 0;
}


#ifdef USB_OTG_HS_INTERNAL_DMA_ENABLED
  #if defined ( __ICCARM__ ) /*!< IAR Compiler */
    #pragma data_alignment=4   
  #endif
#endif /* USB_OTG_HS_INTERNAL_DMA_ENABLED */
__ALIGN_BEGIN USB_OTG_CORE_HANDLE  USB_OTG_dev __ALIGN_END;

/**
  * @}
  */ 


/** @defgroup APP_HID_Private_FunctionPrototypes
  * @{
  */

/**
  * @}
  */ 


/** @defgroup APP_HID_Private_Functions
  * @{
  */ 
#define MOUSE_DELTA           3
#define Buttons buf[0]
#define X  buf[1]
#define Y  buf[2]
void USB_Mouse(void)
{
  unsigned char buf[4];
  unsigned char  ButtonsHold = 0;

  /*Init Buttons*/
  STM_EVAL_PBInit(BUTTON_WAKEUP, BUTTON_MODE_GPIO);

  X = 0;
  Y = 0;
  Buttons = 0;
  ButtonsHold = 0;


  while (!STM_EVAL_PBGetState (BUTTON_TAMPER))
  {
      JoyPos = GetJoystickPosition();
      switch (JoyPos)
      {
      case KEY_UP:
        Y -= MOUSE_DELTA;
        break;
      case KEY_DOWN:
        Y += MOUSE_DELTA;
        break;
      case KEY_LEFT:
        X -= MOUSE_DELTA;
        break;
      case KEY_RIGHT:
        X += MOUSE_DELTA;
        break;
        
      case KEY_UL:
        X -= MOUSE_DELTA;
        Y -= MOUSE_DELTA;
        break;
      case KEY_UR:
        X += MOUSE_DELTA;
        Y -= MOUSE_DELTA;
        break;
      case KEY_DL:
        X -= MOUSE_DELTA;
        Y += MOUSE_DELTA;
        break;
      case KEY_DR:
        X += MOUSE_DELTA;
        Y += MOUSE_DELTA;
        break;
        
      default:
        Y = X = 0;
        break;
      }
      
      if ((GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_6)) == Bit_SET)
        Buttons = Buttons | 0x01;  // left click
      
      if (STM_EVAL_PBGetState (BUTTON_WAKEUP))
        Buttons = Buttons | 0x02; // right click

      if(Y || X  || Buttons || (ButtonsHold ^ Buttons))
      {
        // Send report
        USBD_HID_SendReport (&USB_OTG_dev, buf, 4);
        ButtonsHold = Buttons;
        Y = X = 0;
        Buttons = 0;
      }
  }
  while (STM_EVAL_PBGetState (BUTTON_TAMPER));
}
#undef Buttons
#undef X
#undef Y

/*************************************************************************
 * Function Name: main
 * Parameters: none
 * Return: Int32U
 *
 * Description: The main subroutine
 *
 *************************************************************************/
int main(void)
{

  #ifdef DEBUG
    debug();
  #endif

  // Init clock system
  SystemInit();

  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);  
  
  // LCD init
  LCDInit();  

  LCDContrast(0x45);

  LCDClear();
  LCDStr ( 0, "   Welcome to ", 0 );
  LCDStr ( 1, " STM32F405-STK", 0 );
  LCDStr ( 2, "  development ", 0 );
  LCDStr ( 3, "     board    ", 0 );
  LCDStr ( 5, "www.olimex.com", 1 );
  LCDUpdate();

  // Delay :-)
   for(dly=0; dly<10000000; dly++);
label1:
  // Init joystick
  InitJoystick();
    
  // Draw menu
  UpdateMenu(MenuPos);

  while(1)
  {
    JoyPos = GetJoystickPosition();

    if(JoyPos==KEY_UP)
    {
      MenuPos--;
      if((MenuPos<1))
        MenuPos = 1;
      UpdateMenu(MenuPos);
      for(dly=0; dly<1000000; dly++);
    }

    if(JoyPos==KEY_DOWN)
    {
      MenuPos++;
      if((MenuPos>MENU_NUMB))
        MenuPos = MENU_NUMB;
      UpdateMenu(MenuPos);
      for(dly=0; dly<1000000; dly++);
    }
    

    if(JoyPos==KEY_CENTER)
      break;

  }

  // Demo MMC ------------------------------------------------------------------
  if(MenuPos == 1)
  {
    test_state = DemoMMC();
    switch (test_state)
    {
    case 1:
      LCDClear();
      LCDStr ( 0, " Demo MMC card", 0 );
      LCDStr ( 1, "   SUCCESS!!! ", 0 );
      LCDStr ( 5, "exit          ", 0 );
      LCDUpdate();
      break;
    case 2:
      LCDClear();
      LCDStr ( 0, "  MMC card  ", 0 );
      LCDStr ( 1, "not present!!!", 0 );
      LCDStr ( 5, "exit          ", 0 );
      LCDUpdate();
      break;
    default:
      LCDClear();
      LCDStr ( 0, " Demo MMC card", 0 );
      LCDStr ( 1, "   FAILED!!!  ", 0 );
      LCDStr ( 5, "exit          ", 0 );
      LCDUpdate();
      break;
    }

    while(GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_13) == Bit_RESET);
    goto label1;
  }

  // Demo Audio ----------------------------------------------------------------
  if(MenuPos == 2)
  {
    // WAKE UP
    GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_0;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
    GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
    GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOA, &GPIO_InitStructure);


    LCDClear();
    LCDStr ( 0, "  Audio test  ", 0 );
    LCDStr ( 1, "now in STANDBY", 0 );
    LCDStr ( 2, "press WAKE-UP ", 0 );
    LCDStr ( 3, "to hear audio ", 0 );
    LCDStr ( 5, "         Start", 0 );
    LCDUpdate();

    while(GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_0) == Bit_RESET);
    LCDClear();
    LCDStr ( 0, "  Audio test  ", 0 );
    LCDStr ( 1, "  now is ON   ", 0 );
    LCDStr ( 2, "              ", 0 );
    LCDStr ( 3, "              ", 0 );
    LCDStr ( 5, "exit          ", 0 );
    LCDUpdate();

    // Set STNBY pin
    GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_3;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
    GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
    GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIOC, &GPIO_InitStructure);

    // Chip on
    GPIO_WriteBit(GPIOC, GPIO_Pin_3, Bit_RESET);

    // Microphone and headphone
    ADCInit();
    InitPWM();

    // Enable interrupts
    __enable_interrupt();

    while(GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_13) == Bit_RESET) {

      if((TIM1->SR)&(0x1)) {

        // clear flag
        TIM1->SR &= ~0x1;

        if((jjj++)==3) {
          

          jjj = 0;

          ADCValue = GetADCChanel(ADC_Channel_1);
          ADCValue>>=2;
          SetDutyPeriod(ADCValue);
        }
      }
    }
    goto label1;
  }

  // Test RTC ------------------------------------------------------------------
  if(MenuPos == 3)
  {
    RTCInit();

    LCDClear();
    LCDStr ( 0, "   RTC Test   ", 0 );
    LCDStr ( 1, "STAT LED have ", 0 );
    LCDStr ( 2, "to blink every", 0 );
    LCDStr ( 3, "    second    ", 0 );
    LCDStr ( 5, "exit          ", 0 );
    LCDUpdate();

  // Led PC12 as output
  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOA | RCC_AHB1Periph_GPIOC, ENABLE);

  // Led PC12 as output
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init (GPIOC, &GPIO_InitStructure);
  
    while(GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_13) == Bit_RESET)
      if (RTC->TR & 0x01)
        GPIOC->ODR = GPIOC->ODR | 0x00001000;
      else
        GPIOC->ODR = GPIOC->ODR & 0xFFFFEFFF;
    // Disable RTC
    RCC_RTCCLKCmd(DISABLE);
    // TURN OFF led
    GPIOC->BSRRL |= 0x00001000;
    // restart :-)
    goto label1;
  }

  if(MenuPos == 4)
  {
    Accelerometer_Demo ();
    goto label1;
  }

  // Demo USB ------------------------------------------------------------------
  if(MenuPos == 5)
  {
    static int FirstTime = 1;
    LCDClear();
    LCDStr ( 0, "USB Mouse test", 0 );
    LCDStr ( 1, "       ^      ", 0 );
    LCDStr ( 2, "      < >     ", 0 );
    LCDStr ( 3, "       v      ", 0 );
    LCDStr ( 4, "    LEFT RIGHT", 0 );
    LCDStr ( 5, "END   BUTTONS ", 0 );
    LCDUpdate();

    if (FirstTime)  // initialization
    {
      USBD_Init(&USB_OTG_dev,   
                USB_OTG_FS_CORE_ID,
                &USR_desc, 
                &USBD_HID_cb, 
                &USR_cb);
      FirstTime = 0;
    }
  
    USB_Mouse ();
    goto label1;
  }
}



/*************************************************************************
 * Function Name: DelayResolution100us
 * Parameters: Int32U Dly
 *
 * Return: none
 *
 * Description: Delay ~ (arg * 100us)
 *
 *************************************************************************/
void DelayResolution100us(Int32U Dely)
{
  for(; Dely; Dely--)
  {
    for(volatile Int32U j = DLY_100US; j; j--)
    {
    }
  }
}

#ifdef  USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *   where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif

/**
  * @}
  */

/**
  * @}
  */
#if 0
/*************************************************************************
 * Function Name: __write
 * Parameters: Low Level cahracter output
 *
 * Return:
 *
 * Description:
 *
 *************************************************************************/
size_t __write(int Handle, const unsigned char * Buf, size_t Bufsize)
{
size_t nChars = 0;

  for (/*Empty */; Bufsize > 0; --Bufsize)
  {
    /* Loop until the end of transmission */
    while (USART_GetFlagStatus(EVAL_COM1, USART_FLAG_TXE) == RESET);
    USART_SendData(EVAL_COM1, * Buf++);
    ++nChars;
  }
  return nChars;
}
/*************************************************************************
 * Function Name: __read
 * Parameters: Low Level cahracter input
 *
 * Return:
 *
 * Description:
 *
 *************************************************************************/
size_t __read(int handle, unsigned char * buffer, size_t size)
{
  int nChars = 0;

  /* This template only reads from "standard in", for all other file
   * handles it returns failure. */
  if (handle != _LLIO_STDIN)
  {
    return _LLIO_ERROR;
  }

  for (/* Empty */; size > 0; --size)
  {
    int c = MyLowLevelGetchar();
    if (c < 0)
      break;

    *buffer++ = c;
    ++nChars;
  }

  return nChars;
}

static int MyLowLevelGetchar(void)
{
int ch;
unsigned int status = EVAL_COM1->SR;

  if(status & USART_FLAG_RXNE)
  {
    ch = USART_ReceiveData(EVAL_COM1);
    if(status & (USART_FLAG_ORE | USART_FLAG_PE | USART_FLAG_FE) )
    {
      return (ch | 0x10000000);
    }
    return (ch & 0xff );
  }
  return -1;
}
/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
#endif