// This program shows how to work with ADC convertor
// Press Button 1 -> Send UART0 -> current temperature
// Press Button 2 -> Send UART1 -> current voltage on potentialometer

#include "AT91SAM7S64.h"
#include "stdio.h"
#include "usart.h"
#include "adc.h"
#include "system.h"
#include "string.h"


//MAIN POINTER
AT91PS_PIO    m_pPio   = AT91C_BASE_PIOA;
AT91PS_ADC    m_pADC   = AT91C_BASE_ADC;
AT91PS_RSTC   m_pRSTC  = AT91C_BASE_RSTC;

//it's a simple delay
void Delay (unsigned long a) { while (--a!=0); }

unsigned char* CalcTemp(unsigned int temp);
unsigned char* CalcVolt(unsigned int volt);

unsigned char res[12];

int main()
{



  /**** System init ****/
  InitFrec();
  InitADC();

  /**** UART ****/
  InitUSART0();
  InitUSART1();

  //Initialization
  InitPeriphery();


  while(1)
  {

    //read_char_USART0();

    /*** BUTTONS ***/
    //check button 1 pressed
    if(!((m_pPio->PIO_PDSR) & BIT19)) {
       ClearTerminal();
       CalcTemp(GetValue_chanel5());
       write_str_USART0(res);
       Delay(900000);
    }

    //check button 2 pressed
    if(!((m_pPio->PIO_PDSR) & BIT20)) {
       ClearTerminal();
       CalcVolt(GetValue_chanel4());
       write_str_USART1(res);
       Delay(900000);
    }

  }


}

unsigned char* CalcTemp(unsigned int temp) {

  // This is very simple calculate.
  // It is not exact only demonstrate how to get ADC value

  float T;
  T = (float)temp/2.2 - 228;
  sprintf((char *)res,"Temp %0.1f C",T);

  return 0;
}

unsigned char* CalcVolt(unsigned int volt) {

  // This is very simple calculate.
  // It is not exact only demonstrate how to get ADC value

  float V;
  V = (float)volt * 3.3/1024;
  sprintf((char *)res,"Volt %0.2f V",V);

  return 0;
}

