//uart.h
#include <inarm.h>
#include <stdio.h>
#include <stdlib.h>
#include "board.h"

#define CORECLK_FREQUENCY 30000000

CSP_USART_T * const USART0 = (CSP_USART_T *)USART0_BASE_ADDRESS;
CSP_USART_T * const USART1 = (CSP_USART_T *)USART1_BASE_ADDRESS;

void UARTInitialize(unsigned long baudrate) {

  USART0->ECR   = 0x00000003; // Enable USART clock
  USART0->CR    = 0x0000010D; // Reset
  USART0->PDR   = 0x00070000; // Disable USART PIO
  USART0->MR    = 0x000008C0; // CORECLK, 8 bit, asynchronous, no parity, 1 stop bit, normal mode
  USART0->BRGR  = CORECLK_FREQUENCY / (16 * baudrate);
  USART0->CR    = 0x00000050; // Enable TX and RX
}

void UARTWriteChar(unsigned char ch) {
  while (!(USART0->SR & 0x00000002)); // Wait for TXRDY
  USART0->THR = ch;
}

unsigned char UARTReadChar(void) {

  while (!(USART0->SR & 0x00000001)); // Wait for RXRDY
  return (unsigned char)USART0->RHR;
}


void UARTString(unsigned char* str) {

  char i=0;

  while(str[i] != 0) {
    UARTWriteChar(str[i]);
    i++;
  }
}

void UART1Initialize(unsigned long baudrate) {

  USART1->ECR   = 0x00000002; // Enable USART clock
  USART1->CR    = 0x0000010D; // Reset
  USART1->PDR   = 0x00070000; // Disable USART PIO
  USART1->MR    = 0x000008C0; // CORECLK, 8 bit, asynchronous, no parity, 1 stop bit, normal mode
  USART1->BRGR  = CORECLK_FREQUENCY / (16 * baudrate);
  USART1->CR    = 0x00000050; // Enable TX and RX
}

void UART1WriteChar(unsigned char ch) {
  while (!(USART1->SR & 0x00000002)); // Wait for TXRDY
  USART1->THR = ch;
}

unsigned char UART1ReadChar(void) {

  while (!(USART1->SR & 0x00000001)); // Wait for RXRDY
  return (unsigned char)USART1->RHR;
}

unsigned char UART1ReadChar_nonstop(void) {

  // Wait for RXRDY
  if((USART1->SR & 0x00000001))
    return (unsigned char)USART1->RHR;
  else
    return 0x0;

}


void UART1String(unsigned char* str) {

  char i=0;

  while(str[i] != 0) {
    UART1WriteChar(str[i]);
    i++;
  }
}


