//led.c
#include <ioaduc7020.h>
#include "leds.h"

// Init led ports
void InitLeds(void) {
  GP0DAT=0xC0000000;  //Led 1, Led 2 are outputs
  GP4DAT=0x04000000;  //Led 3 is output

  GP0DAT |= 0x00400000; // Set Led1 port to high (led off)
  GP0DAT |= 0x00800000; // Set Led2 port to high (led off)
  GP4DAT |= 0x00040000; // Set Led3 port to high (led off)


}

// Turn on led 1
void Led1_On(void) {
  GP0DAT &= ~0x00400000;
}

// Turn on led 2
void Led2_On(void) {
  GP0DAT &= ~0x00800000;
}

// Turn on led 3
void Led3_On(void) {
  GP4DAT &= ~0x00040000;
}


// Turn off led 1
void Led1_Off(void) {
  GP0DAT |= 0x00400000;
}

// Turn off led 2
void Led2_Off(void) {
  GP0DAT |= 0x00800000;
}

// Turn off led 1
void Led3_Off(void) {
  GP4DAT |= 0x00040000;
}

