#include "test.h"
#include "mmc.h"
#include <msp430xG46x.h>
#include <string.h>


// mmc variable
extern char mmc_buffer[512];
char mmc_buffer_test_1[512];
char state_mmc = 1;

// ext variable
char state_ext = 1;

unsigned char mask_port_1   = 0x3E;
unsigned char mask_port_2   = 0xBF;
unsigned char mask_port_3   = 0xF0;
//unsigned char mask_port_4   = 0x03|BIT4;
//unsigned char mask_port_5   = 0x7F|BIT7;
unsigned char mask_port_4   = 0x03;
unsigned char mask_port_5   = 0x7F;
unsigned char mask_port_6   = 0x78;
unsigned char mask_port_7   = 0x00;
unsigned char mask_port_8   = 0xF8;
unsigned char mask_port_9   = 0x00FF;
unsigned char mask_port_10  = 0x00FF;

unsigned char state_ext_pin_1   = 100;
unsigned char state_ext_pin_2   = 100;
unsigned char state_ext_pin_3   = 100;
unsigned char state_ext_pin_4   = 100;
unsigned char state_ext_pin_5   = 100;
unsigned char state_ext_pin_6   = 100;
unsigned char state_ext_pin_7   = 100;
unsigned char state_ext_pin_8   = 100;
unsigned char state_ext_pin_9   = 100;
unsigned char state_ext_pin_10  = 100;

unsigned char state_ext_gnd_1   = 0;
unsigned char state_ext_gnd_2   = 0;
unsigned char state_ext_gnd_3   = 0;
unsigned char state_ext_gnd_4   = 0;
unsigned char state_ext_gnd_5   = 0;
unsigned char state_ext_gnd_6   = 0;
unsigned char state_ext_gnd_7   = 0;
unsigned char state_ext_gnd_8   = 0;
unsigned char state_ext_gnd_9   = 0;
unsigned char state_ext_gnd_10  = 0;

unsigned char state_ext_vcc_1   = 0;
unsigned char state_ext_vcc_2   = 0;
unsigned char state_ext_vcc_3   = 0;
unsigned char state_ext_vcc_4   = 0;
unsigned char state_ext_vcc_5   = 0;
unsigned char state_ext_vcc_6   = 0;
unsigned char state_ext_vcc_7   = 0;
unsigned char state_ext_vcc_8   = 0;
unsigned char state_ext_vcc_9   = 0;
unsigned char state_ext_vcc_10  = 0;


// UEXT
unsigned char uext_mask_port_4   = 0x03;
unsigned char uext_mask_port_7   = 0x06;
unsigned char uext_mask_port_8   = 0x38;

unsigned char state_uext_gnd_4  = 0;
unsigned char state_uext_gnd_7  = 0;
unsigned char state_uext_gnd_8  = 0;

unsigned char state_uext_vcc_4  = 0;
unsigned char state_uext_vcc_7  = 0;
unsigned char state_uext_vcc_8  = 0;

unsigned char state_uext_pin_4  = 100;
unsigned char state_uext_pin_7  = 100;
unsigned char state_uext_pin_8  = 100;




void DelayN (unsigned long a) {

  volatile unsigned long d;
  d = a;

  while (--d!=0);
}


unsigned char TestMMC(void) {

  // return value - 0 - mmc error
  // return value - 1 - mmc test ok
  // return value - 2 - mmc card not present error
  // return value - 3 - mmc card write protect error

  // CP - P1.0
  P1SEL &= ~0x01; // gpio
  P1DIR &= ~0x01; // input

  // WP - P7.5
  P7SEL &= ~0x20; // gpio
  P7DIR &= ~0x20; // input

  DelayN(1000);

  // Check first without card - both must be high
  // Card present
  if((P1IN&0x01) != 0x01)  return 2;
  // Write protect
  if((P7IN&0x20) != 0x20)  return 3;

  DelayN(1000);

  // Wait until card present and right protect is low
  while((P1IN&0x01));
  while((P7IN&0x20));

  DelayN(1000);

  if (initMMC() == MMC_SUCCESS)	// card found
  {
    //card_state |= 1;
    memset(&mmc_buffer,0,512);
    mmcReadRegister (10, 16);
    mmc_buffer[7]=0;

    // Fill first Block (0) with 'A'
    memset(&mmc_buffer,'0',512);    //set breakpoint and trace mmc_buffer contents
    mmcWriteBlock(0);
    // Fill second Block (1)-AbsAddr 512 with 'B'
    memset(&mmc_buffer,'1',512);
    mmcWriteBlock(512);

    // Read first Block back to buffer
    memset(&mmc_buffer,0x00,512);
    mmcReadBlock(0,512);
    memset(&mmc_buffer_test_1,'0',512);
    if(strncmp(&mmc_buffer[0], &mmc_buffer_test_1[0], 512)) return 0;

    // Read first Block back to buffer
    memset(&mmc_buffer,0x00,512);
    mmcReadBlock(512,512);
    memset(&mmc_buffer_test_1,'1',512);
    if(strncmp(&mmc_buffer[0], &mmc_buffer_test_1[0], 512)) return 0;

    memset(&mmc_buffer,0x00,512);
  }

  return 1;
}

void Stop(void) {
  // while(1);
}

unsigned char TestEXT(void) {

  unsigned char i;

  //-----------------------------------------------------------------------------------------------------------------
  ////// TEST EXT ////////
  //
  // all as GPIO
  P1SEL = 0x0; P2SEL = 0x0; P3SEL = 0x0; P4SEL = 0x0; P5SEL = 0x0;
  P6SEL = 0x0; P7SEL = 0x0; P8SEL = 0x0; P9SEL = 0x0; P10SEL = 0x0;

  //// Test for GND /////-----------------------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // check for low on port 1
  if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF) { state_ext_gnd_1 = 1; Stop(); return 0; }
  // check for low on port 2
  if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF) { state_ext_gnd_2 = 1; Stop(); return 0; }
  // check for low on port 3
  if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF) { state_ext_gnd_3 = 1; Stop(); return 0; }
  // check for low on port 4
  if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF) { state_ext_gnd_4 = 1; Stop(); return 0; }
  // check for low on port 5
  if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF) { state_ext_gnd_5 = 1; Stop(); return 0; }
  // check for low on port 6
  if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF) { state_ext_gnd_6 = 1; Stop(); return 0; }
  // check for low on port 7
  if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF) { state_ext_gnd_7 = 1; Stop(); return 0; }
  // check for low on port 8
  if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF) { state_ext_gnd_8 = 1; Stop(); return 0; }
  // check for low on port 9
  if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF) { state_ext_gnd_9 = 1; Stop(); return 0; }
  // check for low on port 10
  if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF) { state_ext_gnd_10 = 1; Stop(); return 0; }


  //// Test for VCC /////---------------------------------------
  //
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT &= ~BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT &= ~BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // check for high on port 1
  if((P1IN&mask_port_1) != 0x0) { state_ext_vcc_1 = 1; Stop(); return 0; }
  // check for high on port 2
  if((P2IN&mask_port_2) != 0x0) { state_ext_vcc_2 = 1; Stop(); return 0; }
  // check for high on port 3
  if((P3IN&mask_port_3) != 0x0) { state_ext_vcc_3 = 1; Stop(); return 0; }
  // check for high on port 4
  if((P4IN&mask_port_4) != 0x0) { state_ext_vcc_4 = 1; Stop(); return 0; }
  // check for high on port 5
  if((P5IN&mask_port_5) != 0x0) { state_ext_vcc_5 = 1; Stop(); return 0; }
  // check for high on port 6
  if((P6IN&mask_port_6) != 0x0) { state_ext_vcc_6 = 1; Stop(); return 0; }
  // check for high on port 7
  if((P7IN&mask_port_7) != 0x0) { state_ext_vcc_7 = 1; Stop(); return 0; }
  // check for high on port 8
  if((P8IN&mask_port_8) != 0x0) { state_ext_vcc_8 = 1; Stop(); return 0; }
  // check for high on port 9
  if((P9IN&mask_port_9) != 0x0) { state_ext_vcc_9 = 1; Stop(); return 0; }
  // check for high on port 10
  if((P10IN&mask_port_10) != 0x0) { state_ext_vcc_10 = 1; Stop(); return 0; }


  ///// Running zero ///////-----------------------------------
  //
  ///// for Port1 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 1
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_1)&(1<<i))) continue;

    P1DIR = (1<<i);
    P1OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_1 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_1 = i; Stop(); return 0; }
  }

  ///// for Port2 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 2
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_2)&(1<<i))) continue;

    P2DIR = (1<<i);
    P2OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_2 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_2 = i; Stop(); return 0; }

  }


  ///// for Port3 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 3
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_3)&(1<<i))) continue;

    P3DIR = (1<<i);
    P3OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_3 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_3 = i; Stop(); return 0; }
  }

  ///// for Port4 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 4
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_4)&(1<<i))) continue;

    P4DIR = (1<<i)|BIT4;
    P4OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);


    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_4 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_4 = i; Stop(); return 0; }

  }

  ///// for Port5 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 5
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_5)&(1<<i))) continue;

    P5DIR = (1<<i)|BIT7;
    P5OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_5 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_5 = i; Stop(); return 0; }
  }


  ///// for Port6 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 6
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_6)&(1<<i))) continue;

    P6DIR = (1<<i);
    P6OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_6 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_6 = i; Stop(); return 0; }

  }


  ///// for Port7 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 7
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_7)&(1<<i))) continue;

    P7DIR = (1<<i);
    P7OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_7 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_7 = i; Stop(); return 0; }
  }


  ///// for Port8 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 8
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_8)&(1<<i))) continue;

    P8DIR = (1<<i);
    P8OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_8 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_8 = i; Stop(); return 0; }

  }


  ///// for Port9 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 9
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_9)&(1<<i))) continue;

    P9DIR = (1<<i);
    P9OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != ((0x00FF)&(~(1<<i))))   { state_ext_pin_9 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != 0x00FF)               { state_ext_pin_9 = i; Stop(); return 0; }
  }

  ///// for Port10 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P5.7 and P4.4
  P5OUT |= BIT7;  // high
  P5DIR |= BIT7;  // output
  P4OUT |= BIT4;  // high
  P4DIR |= BIT4;  // output

  // just simple delay
  DelayN(1000);

  // loop for port 10
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((mask_port_10)&(1<<i))) continue;

    P10DIR = (1<<i);
    P10OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P1IN)|((unsigned char)(~mask_port_1))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P2IN)|((unsigned char)(~mask_port_2))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P3IN)|((unsigned char)(~mask_port_3))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P4IN)|((unsigned char)(~mask_port_4))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P5IN)|((unsigned char)(~mask_port_5))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P6IN)|((unsigned char)(~mask_port_6))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~mask_port_7))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~mask_port_8))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P9IN)|((unsigned char)(~mask_port_9))) != 0x00FF)                 { state_ext_pin_10 = i; Stop(); return 0; }
    if(((P10IN)|((unsigned char)(~mask_port_10))) != ((0x00FF)&(~(1<<i)))) { state_ext_pin_10 = i; Stop(); return 0; }
  }

////// TEST EXT END ////////
//---------------------------------------------------------------------------------------------------------

  return 1;
}


unsigned char TestUEXT(void) {

  unsigned char i;

  //-----------------------------------------------------------------------------------------------------------------
  ////// TEST UEXT ////////
  //
  // all as GPIO
  P1SEL = 0x0; P2SEL = 0x0; P3SEL = 0x0; P4SEL = 0x0; P5SEL = 0x0;
  P6SEL = 0x0; P7SEL = 0x0; P8SEL = 0x0; P9SEL = 0x0; P10SEL = 0x0;

  //// Test for GND /////-----------------------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P7.3
  P7OUT |= BIT3;  // high
  P7DIR |= BIT3;  // output

  // just simple delay
  DelayN(1000);

  // check for low on port 4
  if(((P4IN)|((unsigned char)(~uext_mask_port_4))) != 0x00FF) { state_uext_gnd_4 = 1; Stop(); return 0; }
  // check for low on port 7
  if(((P7IN)|((unsigned char)(~uext_mask_port_7))) != 0x00FF) { state_uext_gnd_7 = 1; Stop(); return 0; }
  // check for low on port 8
  if(((P8IN)|((unsigned char)(~uext_mask_port_8))) != 0x00FF) { state_uext_gnd_8 = 1; Stop(); return 0; }


  //// Test for VCC /////---------------------------------------
  //
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P7.3
  P7OUT &= ~BIT3;  // high
  P7DIR |= BIT3;  // output


  // just simple delay
  DelayN(1000);

  // check for high on port 4
  if((P4IN&uext_mask_port_4) != 0x0) { state_ext_vcc_4 = 1; Stop(); return 0; }
  // check for high on port 7
  if((P7IN&uext_mask_port_7) != 0x0) { state_ext_vcc_7 = 1; Stop(); return 0; }
  // check for high on port 8
  if((P8IN&uext_mask_port_8) != 0x0) { state_ext_vcc_8 = 1; Stop(); return 0; }



  ///// Running zero ///////-----------------------------------
  //
  ///// for Port4 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P7.3
  P7OUT |= BIT3;  // high
  P7DIR |= BIT3;  // output


  // just simple delay
  DelayN(1000);

  // loop for port 1
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((uext_mask_port_4)&(1<<i))) continue;

    P4DIR = (1<<i);
    P4OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P4IN)|((unsigned char)(~uext_mask_port_4))) != ((0x00FF)&(~(1<<i))))   { state_uext_pin_4 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~uext_mask_port_7))) != 0x00FF)                 { state_uext_pin_4 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~uext_mask_port_8))) != 0x00FF)                 { state_uext_pin_4 = i; Stop(); return 0; }
  }


  ///// for Port7 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P7.3
  P7OUT |= BIT3;  // high
  P7DIR |= BIT3;  // output


  // just simple delay
  DelayN(1000);

  // loop for port 1
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((uext_mask_port_7)&(1<<i))) continue;

    P7DIR = (1<<i)|BIT3;
    P7OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P4IN)|((unsigned char)(~uext_mask_port_4))) != 0x00FF)                 { state_uext_pin_7 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~uext_mask_port_7))) != ((0x00FF)&(~(1<<i))))   { state_uext_pin_7 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~uext_mask_port_8))) != 0x00FF)                 { state_uext_pin_7 = i; Stop(); return 0; }
  }


  ///// for Port8 --------------------
  // all as input
  P1DIR = 0x0; P2DIR = 0x0; P3DIR = 0x0; P4DIR = 0x0; P5DIR = 0x0;
  P6DIR = 0x0; P7DIR = 0x0; P8DIR = 0x0; P9DIR = 0x0; P10DIR = 0x0;

  // pull up - P7.3
  P7OUT |= BIT3;  // high
  P7DIR |= BIT3;  // output


  // just simple delay
  DelayN(1000);

  // loop for port 1
  for(i=0; i<8; i++) {

    // this port is not tested
    if(!((uext_mask_port_8)&(1<<i))) continue;

    P8DIR = (1<<i);
    P8OUT = ~(1<<i);

    // just simple delay
    DelayN(1000);

    // check port for any zero
    if(((P4IN)|((unsigned char)(~uext_mask_port_4))) != 0x00FF)                 { state_uext_pin_8 = i; Stop(); return 0; }
    if(((P7IN)|((unsigned char)(~uext_mask_port_7))) != 0x00FF)                 { state_uext_pin_8 = i; Stop(); return 0; }
    if(((P8IN)|((unsigned char)(~uext_mask_port_8))) != ((0x00FF)&(~(1<<i))))   { state_uext_pin_8 = i; Stop(); return 0; }
  }


  return 1;

}


