/**********************************************************************************/
/*                                                                                */
/*    Copyright (C) 2005 OLIMEX  LTD.                                             */
/*                                                                                */
/*    Module Name    :  system module                                             */
/*    File   Name    :  system.h                                                  */
/*    Revision       :  01.00                                                     */
/*    Date           :  2005/07/04 initial version                                */
/*                                                                                */
/**********************************************************************************/

#ifndef system_def
#define system_def

/* definitions */

// POWER MODE
#define MODE_ACTIVE  0
#define MODE_LPM0    1
#define MODE_LPM1    2
#define MODE_LPM2    3
#define MODE_LPM3    4
#define MODE_LPM4    5

/****************************************************************************/
/*  Restart proccesor - go to first address                                 */
/*  Function : Restart                                                      */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void Restart(void);

/****************************************************************************/
/*  Init system frequency                                                   */
/*  Function : InitFreq_XT2                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitFreq_XT2(void);

/****************************************************************************/
/*  Init system frequency                                                   */
/*  Function : InitFreq_XT1                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitFreq_XT1(void);

/****************************************************************************/
/*  Init system frequency                                                   */
/*  Function : InitFreq                                                     */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitFreq(void);

/****************************************************************************/
/*  Preparing board to enter sleep mode - low power consumption             */
/*  Function : GoToSleep                                                    */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void GoToSleep(void);

#endif

