/**********************************************************************************/
/*                                                                                */
/*    Copyright (C) 2005 OLIMEX  LTD.                                             */
/*                                                                                */
/*    Module Name    :  system module                                             */
/*    File   Name    :  system.h                                                  */
/*    Revision       :  01.00                                                     */
/*    Date           :  2006/10/05 initial version                                */
/*                                                                                */
/**********************************************************************************/
#include "system.h"
//#include <msp430x44x.h>
#include <msp430xG46x.h>


/****************************************************************************/
/*  Restart proccesor - go to first address                                 */
/*  Function : Restart                                                      */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void Restart(void) {

  typedef void (* Fpnt_t)(void);
  Fpnt_t Fpnt;
  Fpnt = (Fpnt_t)*(unsigned int *)0xFFFE;
  Fpnt();
}


/****************************************************************************/
/*  Init system frequency                                                   */
/*  Function : InitFreq_XT2                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitFreq_XT2(void)
{
  int i=0,j=0;

  // External oscilator 8MHz

  /* Watchdog */
  // Stop watchdog timer
  WDTCTL = WDTPW + WDTHOLD;

  /* FLL+ Control Register 0 */
  // Low Frequency, Oscillator capacitor ~6 pF
  FLL_CTL0 = XCAP0PF;

  /* System Clock Control Register */
  // Disable modulation
  // SCFQCTL = 0x80;

  // Stop DCO
  // _BIS_SR(SCG1+SCG0);
  _BIS_SR(SCG1);

  /* FLL+ Control Register 1 */
  // Activate XT2 high freq xtal
  FLL_CTL1 &= ~XT2OFF;

  // Wait for xtal to stabilize
  do {
  IFG1 &= ~OFIFG;                           // Clear OSCFault flag
  for (i = 5; i > 0; i--);                  // Time for flag to set
  //if((++j)>1000) break;
  }while ((IFG1 & OFIFG));

  /* FLL+ Control Register 1 */
  // SMCLK on, XT2 on, XT2 for main oscilator, ACLK By 1
  FLL_CTL1 = SELM1 + SELS + FLL_DIV_1;

  //  SCFI0 = 0x40;
  //  SCFI1 = 0xE0;


}

/****************************************************************************/
/*  Init system frequency                                                   */
/*  Function : InitFreq_XT1                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitFreq_XT1(void)
{
  // External oscilator 32kHz
  // DCO - off

  /* Watchdog */
  // Stop watchdog timer
  WDTCTL = WDTPW + WDTHOLD;

  /* FLL+ Control Register 1 */
  // SMCLK off, XT2 off, LFXT1CLK for main oscilator, ACLK By 1
  FLL_CTL1 = SMCLKOFF + XT2OFF + SELM0 + SELM1 + FLL_DIV_1;

}

/****************************************************************************/
/*  Init system frequency                                                   */
/*  Function : InitFreq                                                     */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitFreq(void)
{
   /* Watchdog */
   // Stop watchdog timer
   WDTCTL = WDTPW + WDTHOLD;

   /* FLL+ Control Register 0 */
   // Low Frequency, Oscillator capacitor ~6 pF
   //DCO+ set so freq = xtal 2 x N+1
   FLL_CTL0 = DCOPLUS + XCAP10PF;

   /* System Clock Control Register */
   // Enable modulation
   // fDCOCLK = (N + 1) * fcrystal
   // fDCOCLK = (29+1) * 32768 * 2 = 1 966 080 Hz ~ 2MHz
   // SCFQCTL = 29;

   /* System Clock Control Register */
   // Enable modulation
   // fDCOCLK = (N + 1) * fcrystal
   // fDCOCLK = (121+1) * 32768 * 2 = 7 995 392 Hz ~ 8MHz
   SCFQCTL = 121;

   /* FLL+ Control Register 1 */
   // SMCLK on, XT2 off, DCO for main oscilator, ACLK By 1
   // SMCLK clocked from DCO
   FLL_CTL1 = XT2OFF + SELM0 + FLL_DIV_1;

}


/****************************************************************************/
/*  Preparing board to enter sleep mode - low power consumption             */
/*  Function : GoToSleep                                                    */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void GoToSleep(void) {

  // Flash CS high - disable
  P7DIR |= BIT0;
  P7OUT |= BIT0;

  // MMA to sleep mode
  P8OUT &= ~BIT2;

  // LCD turn of light
  P7OUT |= BIT6;

  // IRDA disable
  P7DIR |= BIT7;
  P7OUT |= BIT7;

  // TX - low
  P4DIR |= BIT6;
  P4OUT &= ~BIT6;

  // MMC card
  P3DIR |= (BIT0|BIT2);
  P3OUT |= (BIT0|BIT2);

  // LCD CS high - disable
  P4OUT |= 0x04;
  // LCD RESET
  P7OUT &= ~BIT4;

  // EXT port
  P1DIR |= 0x3E;  P1OUT &= ~0x3E;
  P2DIR |= 0xBF;  P2OUT &= ~0xBF;
  P3DIR |= 0xF0;  P3OUT &= ~0xF0;
  P4DIR |= 0x13;  P4OUT &= ~0x13;
  P5DIR |= 0xFF;  P5OUT &= ~0xFF;
  P6DIR |= 0x17;  P6OUT &= ~0x17;
  P8DIR |= 0xFF;  P8OUT &= ~0xFF;
  P9DIR |= 0xFF;  P9OUT &= ~0xFF;
  P10DIR |= 0xFF;  P10OUT &= ~0xFF;

}


