// rtc.c
#include <msp430xG46x.h>
#include "rtc.h"

unsigned int sec = 0;


/****************************************************************************/
/*  BASIC TIMER/RTC INTERRUPT SOURCE ROUTINE                                */
/*  Function : handle_basictimer_interrupt                                  */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
#pragma vector=BASICTIMER_VECTOR
__interrupt void handle_basictimer_interrupt( void ) {

  P7OUT ^= BIT6;

  // 32768
  RTCNT1 = 0x00;
  RTCNT2 = 0x80;

  // Clear all interupt flag
  P1IFG = 0x0;
  P2IFG = 0x0;
}

void InitRTC(void) {

  // Real-Time Clock Control Register -> ACLK, Counter Mode, 32bit overflow, enable interupt
  RTCCTL = RTCTEV0 + RTCIE;

  // 32768
  RTCNT1 = 0x00;
  RTCNT2 = 0x80;

  // Enable Timer Interupt (RTC in counter mode is like Timer)
  IFG2 = BTIE;

}

