#include <msp430xG46x.h>
#include "periphery.h"
#include "lcd.h"
#include "mma.h"
#include "system.h"

/****************************************************************************/
/*  PORT1 INTERRUPT SOURCE ROUTINE                                          */
/*  Function : handle_port_interrupt                                        */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
#pragma vector=PORT1_VECTOR
__interrupt void handle_port_interrupt( void ) {

  // BUTTON 2 (B2)
  if(P1IFG&0x80) {
    // nothing
  }

  // BUTTON 2 (B2)
  if(P1IFG&0x40) {
   Restart();
  }

  // Clear all interupt flag
  P1IFG = 0x0;
  P2IFG = 0x0;
}

/****************************************************************************/
/*  Init buttons B1 and B2                                                  */
/*  Function : InitButtons                                                  */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitButtons(void) {

  // Ports P1.6, P1.7 as input
  P1DIR   &= ~0xC0;

  // Set high-to-low transition for P1.6, P1.7
  P1IES   |= 0xC0;

  // Enable interupts for P1.6, P1.7
  P1IE    |= 0xC0;

  // Clear all interrupts flag
  P1IFG = 0x0;
  P2IFG = 0x0;

  // Center Button as input
  // gpio
  P2SEL &= ~BIT6;
  // input
  P2DIR &= ~BIT6;

}

/****************************************************************************/
/*  Get value form ADC12 chanel A7                                          */
/*  Function : GetADC12_A7                                                  */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  maesured value                                       */
/****************************************************************************/
unsigned int GetADC12_A7(void) {

    // measured value
  unsigned int val  = 0;

  // clear
  ADC12MCTL0 = 0;

  // ADC12 on
  ADC12CTL0 |= ADC12ON;

  // Input channel select -> A7
  ADC12MCTL0 |= INCH_7;

  // Enable and start conversion
  ADC12CTL0 |= (ADC12SC + ENC);
  // ADC12CTL0 |= ENC;
  // ADC12CTL0 |= ADC12SC;
  ADC12CTL0 &= ~ADC12SC;

  // wait end of conversion
  // while(!(ADC12IFG&0x1));
  while (ADC12CTL1 & ADC12BUSY);


  // Clear interrupt flag
  ADC12IFG = 0;

  // get ADC value
  val = ADC12MEM0;

  // Disable and stop conversion
  ADC12CTL0 &= ~(ADC12SC + ENC);

  // ADC12 off
  // ADC12CTL0 &= ~ADC12ON;

  // return value
  return val;
}


/****************************************************************************/
/*  Init Joystick Button                                                    */
/*  Function : InitJoystick                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitJoystick(void) {

  // Init ADC interface
  InitADC12();

  // A7 as analog input
  P6SEL   |= BIT7;   // P6.7 ADC10 function
  P6DIR   = 0x0;     // P6.7 input direction

  // P2.6 as input
  P2SEL   &= ~BIT6;   // P2.6 as GPIO
  P2DIR   &= ~BIT6;   // P2.6 as input

}

/****************************************************************************/
/*  Init Joystick Button                                                    */
/*  Function : InitJoystick                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Joystick Position                                    */
/****************************************************************************/
JOYSTICK_POS GetJoystickPosition(void) {

  char jresult;
  int  adcresult;
  char nsample;

  adcresult = 0;
  jresult = 0;

  for(nsample=0; nsample<8; nsample++) {
    adcresult += GetADC12_A7();
  }

  adcresult /= (nsample+1);

//  if((adcresult>2080)&&(adcresult<2140))  jresult += J_LEFT;
//  if((adcresult>1300)&&(adcresult<1340))  jresult += J_RIGHT;
//  if((adcresult>2300)&&(adcresult<2360))  jresult += J_UP;
//  if((adcresult>700)&&(adcresult<740))    jresult += J_DOWN;

  if((adcresult>1800)&&(adcresult<2000))  jresult += J_LEFT;
  if((adcresult>1100)&&(adcresult<1300))  jresult += J_RIGHT;
  if((adcresult>2000)&&(adcresult<2200))  jresult += J_UP;
  if((adcresult>550)&&(adcresult<750))    jresult += J_DOWN;


  if(((P2IN&BIT6)==BIT6)&&(adcresult<100)) jresult += J_CENTER;

  return (JOYSTICK_POS)jresult;
}

/****************************************************************************/
/*  Init Gpio port                                                          */
/*  Function : GPIOInit                                                     */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void GPIOInit(void) {

  // all as GPIO
  P1SEL   = 0x00;
  P2SEL   = 0x00;
  P3SEL   = 0x00;
  P4SEL   = 0x00;
  P5SEL   = 0x00;
  P6SEL   = 0x00;
  P7SEL   = 0x00;
  P8SEL   = 0x00;
  P9SEL   = 0x00;
  P10SEL  = 0x00;

  // all as low
  P1OUT   = 0x00;
  P2OUT   = 0x00;
  P3OUT   = 0x00;
  P4OUT   = 0x00;
  P5OUT   = 0x00;
  P6OUT   = 0x00;
  P7OUT   = 0x00;
  P8OUT   = 0x00;
  P9OUT   = 0x00;
  P10OUT  = 0x00;

  // all as output
  P1DIR   = 0xFF;
  P2DIR   = 0xFF;
  P3DIR   = 0xFF;
  P4DIR   = 0xFF;
  P5DIR   = 0xFF;
  P6DIR   = 0xFF;
  P7DIR   = 0xFF;
  P8DIR   = 0xFF;
  P9DIR   = 0xFF;
  P10DIR  = 0xFF;
}


