/**********************************************************************************/
/*                                                                                */
/*    Copyright (C) 2005 OLIMEX  LTD.                                             */
/*                                                                                */
/*    Module Name    :  mma module                                                */
/*    File   Name    :  mma.h                                                     */
/*    Revision       :  01.00                                                     */
/*    Date           :  2006/10/05 initial version                                */
/*                                                                                */
/**********************************************************************************/
#include "mma.h"
//#include <msp430x44x.h>
#include <msp430xG46x.h>

#define NSAMPLE  8

// MMA coordinates array
int Coordinates[3];

/****************************************************************************/
/*  Init ADC12 module                                                       */
/*  Function : InitADC12                                                    */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitADC12(void) {


  /* ADC12 Control Register 0 */
  // ADC12 sample-and-hold time -> 256 x ADC12CLKs,
  // Referance = 2.5V, Select ADC12MEM0
  ADC12CTL0 = SHT03;

  // Sample-and-hold source select -> ADC12SC bit, no clock divider,
  // clock -> ADC12OSC - internal osillator ~5MHz, Single-channel and single-conversion
  // ADC12CTL1 = SHP;

  // Sample-and-hold source select -> ADC12SC bit, no clock divider,
  // clock -> MCLK - external osillator ~2MHz, Single-channel and single-conversion
  // ADC12CTL1 = ADC12SSEL1+SHP;
  ADC12CTL1 = ADC12SSEL1;

  // Conversion Memory Control Registers
  // Select reference -> VR+ = AVCC+ and VR = AVSS
  ADC12MCTL0 = 0x0;


  // A0,A3 as analog input
  P6SEL   |= (BIT0|BIT1|BIT2);    // P6.0, P6.1 and P6.2 -> ADC10 function
  P6DIR   &= ~(BIT0|BIT1|BIT2);   // P6.0, P6.1 and P6.2 -> input direction

}

/****************************************************************************/
/*  Reference generator on                                                  */
/*  Function : ADC12_REFON                                                  */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void ADC12_REFON(void) {

  // Reference generator on
  ADC12CTL0 |= REFON;
}


/****************************************************************************/
/*  Reference generator off                                                 */
/*  Function : ADC12_REFOFF                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void ADC12_REFOFF(void) {

  // Reference generator off
  ADC12CTL0 &= ~REFON;
}

/****************************************************************************/
/*  Get value form ADC12 chanel A0                                          */
/*  Function : GetADC12_A0                                                  */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  maesured value                                       */
/****************************************************************************/
unsigned int GetADC12_A0(void) {

  // measured value
  unsigned int val  = 0;

  // clear
  ADC12MCTL0 = 0;

  // ADC12 on
  ADC12CTL0 |= ADC12ON;

  // Input channel select -> A0
  ADC12MCTL0 |= INCH_0;

  // Enable and start conversion
  ADC12CTL0 |= (ADC12SC + ENC);
  // ADC12CTL0 |= ENC;
  // ADC12CTL0 |= ADC12SC;
  ADC12CTL0 &= ~ADC12SC;

  // wait end of conversion
  // while(!(ADC12IFG&0x1));
  while (ADC12CTL1 & ADC12BUSY);


  // Clear interrupt flag
  ADC12IFG = 0;

  // get ADC value
  val = ADC12MEM0;

  // Disable and stop conversion
  ADC12CTL0 &= ~(ADC12SC + ENC);

  // ADC12 off
  // ADC12CTL0 &= ~ADC12ON;

  // return value
  return val;
}

/****************************************************************************/
/*  Get value form ADC12 chanel A1                                          */
/*  Function : GetADC12_A1                                                  */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  maesured value                                       */
/****************************************************************************/
unsigned int GetADC12_A1(void) {

  unsigned int val  = 0;

  // clear
  ADC12MCTL0 = 0;

  // ADC12 on
  ADC12CTL0 |= ADC12ON;

  // Input channel select -> A1
  ADC12MCTL0 |= INCH_1;

  // Enable i start conversion
  ADC12CTL0 |= (ADC12SC + ENC);
  // ADC12CTL0 |= ENC;
  // ADC12CTL0 |= ADC12SC;
  ADC12CTL0 &= ~ADC12SC;

  // wait end of conversion
  // while(!(ADC12IFG&0x1));
  while (ADC12CTL1 & ADC12BUSY);


  // Clear interrupt flag
  ADC12IFG = 0;

  // get ADC value
  val = ADC12MEM0;

  // Disable and stop conversion
  ADC12CTL0 &= ~(ADC12SC + ENC);

  // ADC10 off
  // ADC12CTL0 &= ~ADC12ON;

  // return value
  return val;

}

/****************************************************************************/
/*  Get value form ADC12 chanel A2                                          */
/*  Function : GetADC12_A2                                                  */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  maesured value                                       */
/****************************************************************************/
unsigned int GetADC12_A2(void) {

  unsigned int val  = 0;

  // clear
  ADC12MCTL0 = 0;

  // ADC12 on
  ADC12CTL0 |= ADC12ON;

  // Input channel select -> A2
  ADC12MCTL0 |= INCH_2;

  // Enable i start conversion
  ADC12CTL0 |= (ADC12SC + ENC);
  // ADC12CTL0 |= ENC;
  // ADC12CTL0 |= ADC12SC;
  ADC12CTL0 &= ~ADC12SC;

  // wait end of conversion
  // while(!(ADC12IFG&0x1));
  while (ADC12CTL1 & ADC12BUSY);

  // Clear interrupt flag
  ADC12IFG = 0;

  // get ADC value
  val += ADC12MEM0;

  // Disable and stop conversion
  ADC12CTL0 &= ~(ADC12SC + ENC);

  // ADC10 off
  // ADC12CTL0 &= ~ADC12ON;

  // return value
  return val;

}

/****************************************************************************/
/*  Get value form ADC12 chanel A11 (measure VCC)                           */
/*  Function : GetADC12_A11                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  maesured value                                       */
/****************************************************************************/
unsigned int GetADC12_A11(void) {

  unsigned int val  = 0;

  // clear
  ADC12MCTL0 = 0;

  // ADC12 on
  ADC12CTL0 |= ADC12ON;

  // Input channel select -> A11
  ADC12MCTL0 |= INCH_11;

  // Enable i start conversion
  ADC12CTL0 |= (ADC12SC + ENC);
  // ADC12CTL0 |= ENC;
  // ADC12CTL0 |= ADC12SC;
  ADC12CTL0 &= ~ADC12SC;

  // wait end of conversion
  // while(!(ADC12IFG&0x1));
  while (ADC12CTL1 & ADC12BUSY);

  // Clear interrupt flag
  ADC12IFG = 0;

  // get ADC value
  val += ADC12MEM0;

  // Disable and stop conversion
  ADC12CTL0 &= ~(ADC12SC + ENC);

  // ADC10 off
  // ADC12CTL0 &= ~ADC12ON;

  // return value
  return val;

}

/****************************************************************************/
/*  Init MMA7620Q Device                                                    */
/*  Function : InitMMA                                                      */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void InitMMA(void) {

  int i;

  // Set G_SEL1, G_SEL2 to low and SM to high
  P8OUT = BIT2;
  P8OUT &= ~BIT0;
  P8OUT &= ~BIT1;

  // Set G_SEL1, G_SEL2 and SM as output
  P8DIR = BIT0 | BIT1 | BIT2;

  // Init ADC
  InitADC12();

}

/****************************************************************************/
/*  Get value form ADC12 chanel A11 (measure VCC)                           */
/*  Function : GetADC12_A11                                                 */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  maesured value                                       */
/****************************************************************************/
unsigned int MeasureHalfVCC(void) {

  unsigned int half_vcc = 0;
  unsigned char i;

  for(i=0; i<8; i++) {
    half_vcc += GetADC12_A11();
  }

  return half_vcc>>3;
}


/****************************************************************************/
/*  Get MMA coordinates (X,Y,Z)                                             */
/*  Function : GetCoordinates                                               */
/*      Parameters                                                          */
/*          Input   :  Nothing                                              */
/*          Output  :  Nothing                                              */
/****************************************************************************/
void GetCoordinates (void) {

  unsigned char n;
  volatile unsigned int i;

  Coordinates[0] = 0;
  Coordinates[1] = 0;
  Coordinates[2] = 0;


  for (n=0; n < NSAMPLE; n++)
  {
      Coordinates[0] += GetADC12_A0();
      Coordinates[1] += GetADC12_A1();
      Coordinates[2] += GetADC12_A2();
  }

  Coordinates[0] /= NSAMPLE;
  Coordinates[1] /= NSAMPLE;
  Coordinates[2] /= NSAMPLE;

}



