//#include <msp430x44x.h>
#include <msp430xG46x.h>
#include "lcd.h"
#include "bmp.h"
#include "ball.h"
#include "bits.h"
#include "font.h"


#define LCD_RESET_LOW     P7OUT &= ~BIT4
#define LCD_RESET_HIGH    P7OUT |= BIT4

#define CS_LOW    P4OUT &= ~0x04;	
#define CS_HIGH   P4OUT |= 0x04;	

void DelayS (unsigned long a) { while (--a!=0); }

unsigned int i,j;

void InitLCD(void) {

  // USART1 initialization for SPI communications //

  // Enable USART0 SPI mode
  U1ME |= USPIE1;

  /* USART Control Register */
  // 8-bit, SPI Master
  UCTL1 = CHAR+SYNC+MM;	

  /* USART Transmit Control Register */
  // Select SMCLK and 3-pin SPI select, Clock Polarity
  //U1TCTL = CKPL+SSEL0+SSEL1+STC+CKPH;	
  //U1TCTL = SSEL0+SSEL1+STC;	
  U1TCTL = SSEL0+SSEL1+STC+CKPL;	

  /* USART Baud Rate Control Register 0 and 1 */
  /* USART Modulation Control Register */
  // Set BoudRate - no devider
  UBR01   = 0x04;	
  UBR11   = 0x00;
  UMCTL1  = 0x00;

  // Setup P4 for SPI1 operation
  P4SEL |= 0x28;		// P4.3 and P4.5 SPI option select

  P4SEL &= ~0x04;		// P4.2 as GPIO
  P4OUT |= 0x04;		// CS high
  P4DIR |= 0x04;		// P4.2 output direction

  // Reset Pin
  P7SEL &= ~0x10;		// P7.4 as GPIO
  P7OUT |= 0x10;		// reset high
  P7DIR |= 0x10;		// P7.4 output direction

  // Backlight
  P7SEL &= ~BIT6;               // P7.6 as GPIO
  P7OUT &= ~BIT6;                // Turn on light
  P7DIR |= BIT6;                // P7.6 output direction
}


void WriteSpiCommand(unsigned int data){

  // Software clock for first bit (must be high)
  P4SEL &= ~0x28; // P4.3 and P4.5 as GPIO
  P4OUT |= 0x20;  // P4.5  -> HIGH
  P4OUT &= ~0x08; // P4.3  -> LOW
  P4DIR |= 0x28;  // P4.3 and P4.5 -> OUTPUT

    // CS Low
  CS_LOW;

  P4OUT &= ~0x20; // P4.5 -> LOW
  P4OUT |= 0x20;  // P4.5 -> HIGH


  P4SEL |= 0x28;  // P4.3 and P4.5 SPI option select

  // USART0 TX buffer ready
  // while ((IFG2 & UTXIFG1) == 0);	
  // while ((U1TCTL & TXEPT) == 0);	

  // Clear Rx flag
  // IFG2 = 0x0;

  // Write byte
  TXBUF1 = data & 0xFF;

  // wait to send data
  while ((U1TCTL & TXEPT) == 0);	

  // CS High
  // CS_HIGH;
}

void WriteSpiData(unsigned int data){

  // Software clock for first bit (must be high)
  P4SEL &= ~0x28; // P4.3 and P4.5 as GPIO
  P4OUT |= 0x28;  // P4.3 and P4.5  -> HIGH
  P4DIR |= 0x28;  // P4.3 and P4.5 -> OUTPUT

  // CS Low
  CS_LOW;

  P4OUT &= ~0x20; // P4.5 -> LOW
  P4OUT |= 0x20;  // P4.5 -> HIGH


  P4SEL |= 0x28;  // P4.3 and P4.5 SPI option select

  // USART0 TX buffer ready
  // while ((IFG2 & UTXIFG1) == 0);		
  // while ((U1TCTL & TXEPT) == 0);	

  // Clear Rx flag
  // IFG2 = 0x0;

  // Write byte
  TXBUF1 = data & 0xFF;

  // wait to send data
  while ((U1TCTL & TXEPT) == 0);	

  // CS High
  // CS_HIGH;
}


void Backlight(unsigned char state) {

  if(state == BKLGHT_LCD_ON)
      P7OUT |= BIT6;    //Turn on light
  else
      P7OUT &= ~BIT6;    //Turn off light
}

void SetContrast(unsigned char contrast) {

#ifdef GE12
  WriteSpiCommand(CONTRAST);
  WriteSpiData(0x20+contrast);    // contrast
#else

#endif

}

void LCDSettings(void) {

#ifdef GE12

  // Hardware reset
  //LCD_RESET_LOW;
  //Delaya(2000);
  //LCD_RESET_HIGH;
  //Delaya(2000);


  ///// Initialization start /////

  // 2. Software Reset
  WriteSpiCommand(SOFTRST);
  DelayS(2000);


  // 3. Initial escape
  WriteSpiCommand(INITESC);
  DelayS(2000);

  ///// Initialization end /////


  ///// Display setting 1 /////

  // 1. Refresh set
  WriteSpiCommand(REFSET);
  WriteSpiData(0);


  // 2. Display control - 7 parameters
  WriteSpiCommand(DISPCTRL);
  WriteSpiData(128);     // Set the lenght of one selection term
  WriteSpiData(128);     // Set N inversion -> no N inversion
  WriteSpiData(134);     // Set frame frequence and bias rate -> 2 devision of frequency and 1/8 bias, 1/67 duty, 96x67 size
  WriteSpiData(84);      // Set duty parameter
  WriteSpiData(69);      // Set duty parameter
  WriteSpiData(82);      // Set duty parameter
  WriteSpiData(67);      // Set duty parameter


  // 3.1 Grey scale 0 position set - 15 parameters
  WriteSpiCommand(GRAYSCALE0);
  WriteSpiData(1);     // GCP1 - gray lavel to be output when the RAM data is "0001"
  WriteSpiData(2);     // GCP2 - gray lavel to be output when the RAM data is "0010"
  WriteSpiData(4);     // GCP3 - gray lavel to be output when the RAM data is "0011"
  WriteSpiData(8);     // GCP4 - gray lavel to be output when the RAM data is "0100"
  WriteSpiData(16);    // GCP5 - gray lavel to be output when the RAM data is "0101"
  WriteSpiData(30);    // GCP6 - gray lavel to be output when the RAM data is "0110"
  WriteSpiData(40);    // GCP7 - gray lavel to be output when the RAM data is "0111"
  WriteSpiData(50);    // GCP8 - gray lavel to be output when the RAM data is "1000"
  WriteSpiData(60);    // GCP9 - gray lavel to be output when the RAM data is "1001"
  WriteSpiData(70);    // GCP10 - gray lavel to be output when the RAM data is "1010"
  WriteSpiData(80);    // GCP11 - gray lavel to be output when the RAM data is "1011"
  WriteSpiData(90);    // GCP12 - gray lavel to be output when the RAM data is "1100"
  WriteSpiData(100);   // GCP13 - gray lavel to be output when the RAM data is "1101"
  WriteSpiData(110);   // GCP14 - gray lavel to be output when the RAM data is "1110"
  WriteSpiData(127);   // GCP15 - gray lavel to be output when the RAM data is "1111"

  // 4. Gamma curve set - select gray scale - GRAYSCALE 0 or GREYSCALE 1
  WriteSpiCommand(GAMMA);
  WriteSpiData(1);     // Select grey scale 0


  // 5. Command driver output
  WriteSpiCommand(COMMONDRV);
  WriteSpiData(0);     // Set COM1-COM41 side come first, normal mod


  // 6. Set Normal mode (my)
  WriteSpiCommand(NORMALMODE);

  // 7. Inversion off
  // WriteSpiCommand(INVERSIONOFF);

  // 8. Column address set
  WriteSpiCommand(COLADDRSET);
  WriteSpiData(0);
  WriteSpiData(131);
  //WriteSpiData(0);

  // 9. Page address set
  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(0);
  WriteSpiData(131);
  //WriteSpiData(0);



  // 10. Memory access controler
  WriteSpiCommand(ACCESSCTRL);
  WriteSpiData(0x40);     // horizontal
  //WriteSpiData(0x20);   // vertical

  ///// Display setting 1 end  /////


  ///// Power supply  ///////

  // 1. Power control
  WriteSpiCommand(PWRCTRL);
  WriteSpiData(4);     // Internal resistance, V1OUT -> high power mode, oscilator devision rate
  // WriteSpiData(0x44);     // Internal resistance, V1OUT -> high power mode, oscilator devision rate

  // 2. Sleep out
  WriteSpiCommand(SLEEPOUT);


  // 3. Voltage control - voltage control and write contrast define LCD electronic volume
  WriteSpiCommand(VOLTCTRL);
  //WriteSpiData(0x7f);    //  full voltage control
  //WriteSpiData(0x03);    //  must be "1"

  // 4. Write contrast
  WriteSpiCommand(CONTRAST);
  WriteSpiData(0x30);    // contrast

  DelayS(2000);

  // 5. Temperature gradient
  WriteSpiCommand(TEMPGRADIENT);
  for(i=0; i<14; i++) {
    WriteSpiData(0);
  }

  // 6. Booster voltage ON
  WriteSpiCommand(BOOSTVON);


  // Finally - Display On
  WriteSpiCommand(DISPLAYON);	

#else

  // Display vontrol
  WriteSpiCommand(DISCTL);
//  WriteSpiData(0x03); // no division
//  WriteSpiData(0x23); // 160 line
//  WriteSpiData(0x02); // 2 highlighte line
/*
  WriteSpiData(0x00); // default
  WriteSpiData(0x20); // (32 + 1) * 4 = 132 lines (of which 130 are visible)
  WriteSpiData(0x0a); // default
*/

  WriteSpiData(0x00); // default
  WriteSpiData(0x20); // (32 + 1) * 4 = 132 lines (of which 130 are visible)
  WriteSpiData(0x0a); // default


  // COM scan
  WriteSpiCommand(COMSCN);
  WriteSpiData(0x01);  // Scan 1-80

  // Internal oscilator ON
  WriteSpiCommand(OSCON);

  // Sleep out
  WriteSpiCommand(SLPOUT);

  // Voltage control
  WriteSpiCommand(VOLCTR);
  WriteSpiData(0x1F); // middle value of V1
  WriteSpiData(0x03); // middle value of resistance value

  // Temperature gradient
  WriteSpiCommand(TMPGRD);
  WriteSpiData(0x00); // default

  // Power control
  WriteSpiCommand(PWRCTR);
  WriteSpiData(0x0f);   // referance voltage regulator on, circuit voltage follower on, BOOST ON

  // Normal display
  WriteSpiCommand(DISNOR);

  // Inverse display
  WriteSpiCommand(DISINV);

  // Partial area off
  WriteSpiCommand(PTLOUT);

//  // Scroll area set
//  WriteSpiCommand(ASCSET);
//  WriteSpiData(0);
//  WriteSpiData(0);
//  WriteSpiData(40);
//  WriteSpiData(3);

//  // Vertical scrool address start
//  WriteSpiCommand(SCSTART);
//  WriteSpiData(0);


  // Data control
  WriteSpiCommand(DATCTL);
  WriteSpiData(0x00); // all inversions off, column direction
  // WriteSpiData(0x00); // BGR sequence
  WriteSpiData(0x01); // RGB sequence
  WriteSpiData(0x02); // 4k color

  // Page Address set
  WriteSpiCommand(PASET);
  WriteSpiData(0);
  WriteSpiData(131);

  // Page Column set
  WriteSpiCommand(CASET);
  WriteSpiData(0);
  WriteSpiData(131);

  // wait ~100ms
  DelayS(10000);

#endif

}


void LCDWrite130x130bmp(void) {

  int size;
  size = sizeof(bmp);

#ifdef GE12

  // Display OFF
  WriteSpiCommand(DISPLAYOFF);

  // WRITE MEMORY
  WriteSpiCommand(MEMWRITE);

  // write to memory
  for(j=0; j<size; j++) {
    WriteSpiData(0xFF);
    //WriteSpiData(bmp[i]);
  }

  // Display On
  WriteSpiCommand(DISPLAYON);	

#else

  // WRITE MEMORY
  WriteSpiCommand(RAMWR);

  for(j=0; j<size; j++) {
    //WriteSpiData(bmp[j]);
    WriteSpiData(0xFF);
  }

  // wait ~100ms
  DelayS(10000);

  // Display On
  WriteSpiCommand(DISON);	

#endif


}

void ClearLCD(void) {

  int size;
  size = sizeof(bmp);

#ifdef GE12

  // Page address set
  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(0);
  WriteSpiData(131);

  // Column address set
  WriteSpiCommand(COLADDRSET);
  WriteSpiData(0);
  WriteSpiData(131);

  // WRITE MEMORY
  WriteSpiCommand(MEMWRITE);

  // write to memory
  for(j=0; j<size; j++) {
    WriteSpiData(0xFF);
  }

  // Display On
  WriteSpiCommand(DISPLAYON);	

#else

  // Page address set
  WriteSpiCommand(PASET);
  WriteSpiData(0);
  WriteSpiData(131);

  // Page Column set
  WriteSpiCommand(CASET);
  WriteSpiData(0);
  WriteSpiData(131);

  // WRITE MEMORY
  WriteSpiCommand(RAMWR);

  // write to memory
  for(j=0; j<size; j++) {
    WriteSpiData(0xFF);
  }

  // wait ~100ms
  DelayS(10000);

  // Display On
  WriteSpiCommand(DISON);	

#endif

}

void ClearBall(unsigned char row, unsigned char col) {

#ifdef GE12

  // Page address set
  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(row);
  WriteSpiData(row+19);

  // Column address set
  WriteSpiCommand(COLADDRSET);
  WriteSpiData(col);
  WriteSpiData(col+19);

  // WRITE MEMORY
  WriteSpiCommand(MEMWRITE);

  for(j=0; j<600; j++) {
    WriteSpiData(0xff);
  }

  // Display On

  WriteSpiCommand(DISPLAYON);

#else

  // Page address set
  WriteSpiCommand(PASET);
  WriteSpiData(row);
  WriteSpiData(row+19);

  // Column address set
  WriteSpiCommand(CASET);
  WriteSpiData(col);
  WriteSpiData(col+19);

  // WRITE MEMORY
  WriteSpiCommand(RAMWR);

  for(j=0; j<600; j++) {
    WriteSpiData(0xff);
  }

  // Display On

  WriteSpiCommand(DISON);

#endif

}

void WriteBall(unsigned char row, unsigned char col) {

#ifdef GE12

  // Page address set
  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(row);
  WriteSpiData(row+19);

  // Column address set
  WriteSpiCommand(COLADDRSET);
  WriteSpiData(col);
  WriteSpiData(col+19);

  // WRITE MEMORY
  WriteSpiCommand(MEMWRITE);

  for(j=0; j<600; j++) {
    WriteSpiData(ball[j]);
  }

  // Display On
  //WriteSpiCommand(DISPLAYON);

#else

  // Page address set
  WriteSpiCommand(PASET);
  WriteSpiData(row);
  WriteSpiData(row+19);

  // Column address set
  WriteSpiCommand(CASET);
  WriteSpiData(col);
  WriteSpiData(col+19);

  // WRITE MEMORY
  WriteSpiCommand(RAMWR);

  for(j=0; j<600; j++) {
    WriteSpiData(ball[j]);
  }

#endif

}


void LCDWriteTestSuccess(void) {

#ifdef GE12

  ClearLCD();

  int size;
  size = sizeof(success);

  // Page address set
  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(0);
  WriteSpiData(30);

  // Column address set
  WriteSpiCommand(COLADDRSET);
  WriteSpiData(0);
  WriteSpiData(130);

  // WRITE MEMORY
  WriteSpiCommand(MEMWRITE);

  // write to memory
  for(j=0; j<size; j++) {
    WriteSpiData(success[j]);
  }

  // Display On
  WriteSpiCommand(DISPLAYON);	

#else

  ClearLCD();

  int size;
  size = sizeof(success);

  // Page address set
  WriteSpiCommand(PASET);
  WriteSpiData(0);
  WriteSpiData(30);

  // Column address set
  WriteSpiCommand(CASET);
  WriteSpiData(0);
  WriteSpiData(130);

  // WRITE MEMORY
  WriteSpiCommand(RAMWR);

  // write to memory
  for(j=0; j<size; j++) {
    WriteSpiData(success[j]);
  }

  // Display On
  WriteSpiCommand(DISON);	

#endif

}

void LCDWriteTestFailed(void) {

#ifdef GE12

  ClearLCD();

  int size;
  size = sizeof(failed);

  // Page address set
  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(0);
  WriteSpiData(30);

  // Column address set
  WriteSpiCommand(COLADDRSET);
  WriteSpiData(0);
  WriteSpiData(130);

  // WRITE MEMORY
  WriteSpiCommand(MEMWRITE);

  // write to memory
  for(j=0; j<size; j++) {
    WriteSpiData(failed[j]);
  }

  // Display On
  WriteSpiCommand(DISPLAYON);	

#else

  ClearLCD();

  int size;
  size = sizeof(failed);

  // Page address set
  WriteSpiCommand(PASET);
  WriteSpiData(0);
  WriteSpiData(30);

  // Column address set
  WriteSpiCommand(CASET);
  WriteSpiData(0);
  WriteSpiData(130);

  // WRITE MEMORY
  WriteSpiCommand(RAMWR);

  // write to memory
  for(j=0; j<size; j++) {
    WriteSpiData(failed[j]);
  }

  // Display On
  WriteSpiCommand(DISON);	

#endif

}

void LCDWriteChar(unsigned char Ascii,
                  unsigned char xb, unsigned char xe,
                  unsigned char yb, unsigned char ye,
                  unsigned short FG_Colour, unsigned short BG_Colour) {

#ifdef GE12

  unsigned char Byte_1;
  unsigned char Byte_2;
  unsigned char Byte_3;
  unsigned char Pixel;

  WriteSpiCommand(COLADDRSET);
  WriteSpiData(xb);
  WriteSpiData(xe);

  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(yb);
  WriteSpiData(ye);

  WriteSpiCommand(MEMWRITE);

  for(j=0; j<16; j++) {
    Pixel = font_digits[j+(16*Ascii)];
    for(i=0;i<8;i++)
    {
        if(i%2)
        {
            if(Pixel&0x80)      // Pixel ON
            {
                Byte_2 &= 0xF0;
                Byte_2 |= FG_Colour >> 8;
                Byte_3 = FG_Colour&0x00FF;
            }
            else                // Pixel OFF
            {
                Byte_2 &= 0xF0;
                Byte_2 |= BG_Colour >> 8;
                Byte_3 =  BG_Colour&0x00FF;
            }
        WriteSpiData(Byte_1);
        WriteSpiData(Byte_2);
        WriteSpiData(Byte_3);
        }
        else
        {
            if(Pixel&0x80)      // Pixel ON
            {
                Byte_1 = FG_Colour >> 4;
                Byte_2 = FG_Colour << 4;
            }
            else                // Pixel OFF
            {
                Byte_1 = BG_Colour >> 4;
                Byte_2 = 0;
                Byte_2 |= BG_Colour << 4;
            }
        }
        Pixel <<= 1;
    }
  }

#else

#endif

}

void LCDWriteArrow(unsigned char arr,
                   unsigned char xb, unsigned char xe,
                   unsigned char yb, unsigned char ye,
                   unsigned short FG_Colour, unsigned short BG_Colour) {

#ifdef GE12

  unsigned char Byte_1;
  unsigned char Byte_2;
  unsigned char Byte_3;
  unsigned char Pixel;

  WriteSpiCommand(COLADDRSET);
  WriteSpiData(xb);
  WriteSpiData(xe);

  WriteSpiCommand(PAGEADDRSET);
  WriteSpiData(yb);
  WriteSpiData(ye);

  WriteSpiCommand(MEMWRITE);

  for(j=0; j<16; j++) {
    if(arr == 0)      Pixel = right_arrow[j];
    if(arr == 1)      Pixel = left_arrow[j];
    if(arr == 2)      Pixel = up_arrow[j];
    if(arr == 3)      Pixel = down_arrow[j];


    for(i=0;i<8;i++)
    {
        if(i%2)
        {
            if(Pixel&0x80)      // Pixel ON
            {
                Byte_2 &= 0xF0;
                Byte_2 |= FG_Colour >> 8;
                Byte_3 = FG_Colour&0x00FF;
            }
            else                // Pixel OFF
            {
                Byte_2 &= 0xF0;
                Byte_2 |= BG_Colour >> 8;
                Byte_3 =  BG_Colour&0x00FF;
            }
        WriteSpiData(Byte_1);
        WriteSpiData(Byte_2);
        WriteSpiData(Byte_3);
        }
        else
        {
            if(Pixel&0x80)      // Pixel ON
            {
                Byte_1 = FG_Colour >> 4;
                Byte_2 = FG_Colour << 4;
            }
            else                // Pixel OFF
            {
                Byte_1 = BG_Colour >> 4;
                Byte_2 = 0;
                Byte_2 |= BG_Colour << 4;
            }
        }
        Pixel <<= 1;
    }
  }
#else

#endif

}

/*
void ShowTemp(void)
{
  char Tempbuf[] = {0x32,0x38,0x34,0x35};

  LCDWriteChar('t',0x10,0x17,0x10,0x1f,0x0070,0x01EF);
  LCDWriteChar((Tempbuf[0]),0x20,0x27,0x10,0x1f,0x0070,0x01EF);
  LCDWriteChar((Tempbuf[1]),0x28,0x2F,0x10,0x1f,0x0070,0x01EF);
  LCDWriteChar('.',0x30,0x37,0x10,0x1f,0x0070,0x01EF);
  LCDWriteChar((Tempbuf[3]),0x38,0x3F,0x10,0x1f,0x0070,0x01EF);
  LCDWriteChar(0x1F,0x43,0x4A,0x10,0x1f,0x0070,0x01EF);
  LCDWriteChar('C',0x4B,0x52,0x10,0x1f,0x0070,0x01EF);
}

void ShowTime(void)
{
  char Hour = 0x11;
  char Minute = 0x23;
  char Second = 0x48;

  LCDWriteChar(((Hour >> 4) + '0'),0x10,0x17,0x20,0x2f,0x0070,0x01EF);
  LCDWriteChar(((Hour&0x0F) + '0'),0x18,0x1F,0x20,0x2f,0x0070,0x01EF);
  LCDWriteChar(':',0x22,0x29,0x20,0x2f,0x0070,0x01EF);
  LCDWriteChar(((Minute >> 4) + '0'),0x28,0x2F,0x20,0x2f,0x0070,0x01EF);
  LCDWriteChar(((Minute&0x0F) + '0'),0x30,0x37,0x20,0x2f,0x0070,0x01EF);
  LCDWriteChar(':',0x3A,0x41,0x20,0x2f,0x0070,0x01EF);
  LCDWriteChar(((Second >> 4) + '0'),0x40,0x47,0x20,0x2f,0x0070,0x01EF);
  LCDWriteChar(((Second&0x0F) + '0'),0x48,0x4F,0x20,0x2f,0x0070,0x01EF);
}
*/

