#include <msp430xG46x.h>
#include "irda.h"

void InitUCA_UART(void) {

  // msb first, no parity, one stop, 8 bit
  UCA0CTL0 = UCSWRST;
  UCA0CTL0 = 0;

  // clock -> SMCLK
  UCA0CTL1 = UCSSEL1;

  // Set 9600 baud rate
  // SMCLK  = 8 MHz
  UCA0BR0   = 0x41;		
  UCA0BR1   = 0x03;	
  UCA0MCTL  = 0x00;

//*  // Set 9600 baud rate
//*  // SMCLK  = 2 MHz
//*  UCA0BR0   = 0xD0;		
//*  UCA0BR1   = 0x00;	
//*  UCA0MCTL  = 0x00;

//*  // Set 9600 baud rate
//*  // ACLK  = 32768 Hz
//*  UCA0BR0   = 0x03;		
//*  UCA0BR1   = 0x00;	
//*  UCA0MCTL  = 0x4A;

  // IrDA encoder/decoder enabled - pulse lenght 5
  UCA0IRTCTL = UCIREN + UCIRTXPL5;


  // second functionality of pin
  P4SEL |= 0xc0;		// P4.6,47 UART option select
  P4DIR |= 0x40;		// P4.6 output direction

  // P7.7 - as otuput
  P7SEL &= ~0x80; // gpio
  P7DIR |= 0x80;  // output
  P7OUT |= 0x80;  // high/disable

}

void IRDAEnable(void) {

  // P7.7 to low
  P7OUT &= ~0x80;
}

void IRDADisable(void) {

  // P7.7 to high
  P7OUT |= 0x80;
}

void WriteByteUCA_UART(unsigned char data) {

  //while ((IFG2&UCA0TXIFG)==0);	// wait while not ready
  while(UCA0STAT&UCBUSY);
  UCA0TXBUF = data;		// write
}

unsigned char ReadByteUCA_UART(void) {

  //while ((IFG2&UCA0RXIFG)==0);	// wait for RX buffer (full)
  while(UCA0STAT&UCBUSY);
  return (UCA0RXBUF);
}


void InitIRDA(void) {

  // init uart interface
  InitUCA_UART();

  // enable module
  IRDAEnable();

}

unsigned char TestIRDA(void) {

  unsigned char i;
  unsigned char sample;
  unsigned char success;

  sample = 32;
  success = 0;

  InitIRDA();


  for(i=0; i<sample; i++) {

    WriteByteUCA_UART(0x55);

    if(ReadByteUCA_UART() == 0x55) {
      success++;
      break;
    }
  }


  for(i=0; i<sample; i++) {

    WriteByteUCA_UART(0x11);

    if(ReadByteUCA_UART() == 0x11) {
      success++;
      break;
    }
  }

  for(i=0; i<sample; i++) {

    WriteByteUCA_UART(0xA0);

    if(ReadByteUCA_UART() == 0xA0) {
      success++;
      break;
    }
  }

  for(int i=0; i<sample; i++) {

    WriteByteUCA_UART(0x66);

    if(ReadByteUCA_UART() == 0x66) {
      success++;
      break;
    }
  }

  if(success == 4)
    return 1;
  else
    return 0;
}

