/*	Sample program for Olimex AVR-P40 with ATMega16 processor
 *	Using Hyper Terminal
 *	Ouput Menu with 4 actions as follow:
 *	1 - LED Turn ON; 2 - LED Turn OFF; 3 - Toggle LED State
 *	4 - blinking LED while button is pressed until keypressed
 *	In order to work, connect the TX pad with PD1(pin 15) and RX pad with PD0(pin 14)
 *	Compile with AVRStudio+WinAVR (gcc version 3.4.6)
 */

#define	__AVR_ATmega16__	1
#define OSCSPEED	8000000		/* in Hz */

#include "avr/io.h"

char Text1[80];

void Init(void)
{
	PORTB = 0x01;
	PORTC = 0x00;
	PORTD = 0x00;

	DDRB = 0x01;
	DDRC = 0x00;
	DDRD = 0x00;
}

void UartInit(uint32_t Baud)
{
	int BaudRate = OSCSPEED / (16 * Baud) - 1;

	UBRRH = (unsigned char) BaudRate>>8;
	UBRRL = (unsigned char) BaudRate;
	//set BaudRate

	UCSRB = UCSRB | (0b00011000); 
	// RXEN & TXEN enable (Bits 4, 3 = 1)

	UCSRC = (UCSRC | (0b10000110)); 
	// USART Register Select (Bit 7 = 1)
	// 8 data bits per frame (Bit 2, 1 = 1)

	UCSRC = UCSRC & 0b11110111;
	// 1 Stop bit (Bit 3 = 0)	
}

unsigned char UartReceive(void)
{
	if (UCSRA & 0b10000000)
	//if RXC(Bit 7) = 1 
		return UDR;
	else
		return 0;
}

void UartTransmit(unsigned char Data)
{
	while (!(UCSRA & 0b00100000));
	//while UDRE = 0 --> ;
	UDR = Data;
}

void LedMode (unsigned char Temp)
{
	switch (Temp)
	{
	// 1 - LED ON
	case 1: PORTB = PORTB & 0&11111110; break;
	// 2 - Led OFF
	case 2: PORTB = PORTB | 0b00000001; break;
	// 3 - Toggle Led
	case 3: if (PINB & 0b00000001) PORTB = PORTB & 0b11111110;
							else	PORTB = PORTB | 0b00000001; break;
	}
}



unsigned char Length(char Temp[20])
{
	unsigned char L=0;
	while (Temp[L]) L++;
	return L;
}

void Write(char Text[80])
{
	unsigned char Len, i, T;
	Len = Length(Text);
	//UartTransmit(Len);
	for (i=0; i<Len; i++) 
	{
		T = Text[i];
		UartTransmit(T);
	}
	strcpy(Text, "");
}

void WriteLn(char Text[80])
{
	unsigned char Len, i, T;
	Len = Length(Text);
	//UartTransmit(Len);
	for (i=0; i<Len; i++) 
	{
		T = Text[i];
		UartTransmit(T);
	}
	strcpy(Text, "");
	UartTransmit(10);
	UartTransmit(13);
}

void BlinkLed(void)
{
	unsigned int Br;
	unsigned char State, End=0;
	State = PINB;
	WriteLn("");
	strcpy(Text1, "Press any Key");
	WriteLn(Text1);
	while (End == 0)
	{
		End = UartReceive();
		if ((End == 0) & (!(PINB & 0b00010000)))
		{
			LedMode(3);
			for (Br = 20000; Br; Br--);
		}		
	}
	PORTB = State;	
}

int main()
{
	Init();
	UartInit(9600);
	unsigned char Action = 0, Bl;
	while (1)
	{
		Action = 0;
		Bl = 1;
		WriteLn("");
		strcpy(Text1, "Menu");	
		WriteLn(Text1);
		strcpy(Text1, "1) Led ON");	
		WriteLn(Text1);
		strcpy(Text1, "2) Led OFF");	
		WriteLn(Text1);
		strcpy(Text1, "3) Toggle Led");	
		WriteLn(Text1);
		strcpy(Text1, "4) Hold Button to Blink Led");	
		WriteLn(Text1);
		strcpy(Text1, "Choose Action: ");
		Write(Text1);

		while (Bl)
		{
			Action = UartReceive();
			if (Action)	Action = Action - 48;
			if (Action)
			{
				Bl = 0;
				switch (Action)
				{
					case 1: LedMode(Action); WriteLn(""); break;
					case 2: LedMode(Action); WriteLn(""); break;
					case 3: LedMode(Action); WriteLn(""); break;
					case 4: BlinkLed(); WriteLn(""); break;
					default: WriteLn("No such action."); break;
				}				
			}
		}
	}
	return 0;
}
