/*	Sample program for Olimex AVR-P40 with ATMega16 processor
 *	Echoes back the received characters on the uart. In order to work,
 *	connect the RX pad with PD1(pin 15) and TX pad with PD0(pin 14)
 *	Compile with AVRStudio+WinAVR (gcc version 3.4.6)
 */

#define	__AVR_ATmega16__	1
#define OSCSPEED	8000000		/* in Hz */

#include "avr/io.h"


void Initialize(void)
{
	PORTB = 0x1;
	PORTC = 0x0;
	PORTD = 0x0;

	DDRB = 0x1;
	DDRC = 0x0;
	DDRD = 0x0;
}

void  UARTInit(uint32_t Baud)
{
	unsigned int BaudRate = OSCSPEED / (16 * Baud) - 1;
	UBRRH = (unsigned char) (BaudRate>>8);
	UBRRL = (unsigned char) BaudRate;
	UCSRB = UCSRB | 0b00011000;
	UCSRC = UCSRC | 0b10000110;
}

unsigned char UARTReceive(void)
{
	if (UCSRA & 0b10000000)
		return UDR;
	else
		return 0;
}

void UARTTransmit(unsigned char Data)
{
	while (!(UCSRA & 0b00100000));
	UDR = Data;
}

int main()
{
	unsigned char ch;
	Initialize();
	UARTInit(9600);
	while (1)
	{
		ch = UARTReceive();
		if (ch)
		{
			UARTTransmit(ch);

		}
	}	
}
