/*	Sample program for Olimex AVR-P40 with ATMega16 processor
 *	Toggles the Led On when the button is pressed
 *	Compile with AVRStudio+WinAVR (gcc version 3.4.6) */

#define	__AVR_ATmega16__	1

#include "avr/io.h"

void Initialize()
{
	PORTB = 0x1;
	PORTC = 0x0;
	PORTD = 0x0;
	
	DDRB = 0x1;
	DDRC = 0x0;
	DDRD = 0x0;
}

/*	Mode:
	0) Led On;
	1) Led Off;
	2) Blink Led;
	else Toggle Led; */

void LedMode(unsigned char Temp)
{
	int Time;
	switch (Temp)
	{
		case 0: PORTB = PORTB & 0b11111110;
				break;
		case 1: PORTB = PORTB | 0b00000001;
				break;
		case 2: PORTB = PORTB & 0b11111110; for (Time=20000; Time; Time--);
				PORTB = PORTB & 0b00000001; for (Temp=20000; Temp; Temp--);
				break;
		default: if (PINB & 0b00000001)	PORTB = PORTB & 0b11111110;
								else	PORTB = PORTB | 0b00000001;
				break;
	}
}

int main()
{
	Initialize();
	while (1)
	{
		if (PINB & 0b00010000)
			LedMode(1);
		else
			LedMode(0);
	}
		
}
