/*	Sample program for Olimex AVR-P40 with ATMega16 processor
 *	Blinks the led with a speed ~2Hz using a simple delay loop.
 *	Compile with AVRStudio+WinAVR (gcc version 3.4.6)*/ 

#define	__AVR_ATmega16__	1
#define OSCSPEED	8000000		/* in Hz */

#include "avr/io.h"


void Initialize()
{
	PORTB = 0x01; //Led is set off
	PORTC = 0x00;
	PORTD = 0x00;

	DDRB = 0x01; // Led is set as output
	DDRC = 0x00;
	DDRD = 0x00;
	
}

/*	Mode:
	0) Led On;
	1) Led Off;
	2) Blink Led;
	else Toggle Led; */
int Mode=1;

void LedMode(unsigned char Temp)
{
	int Time;
	switch (Temp)
	{
		case 0: PORTB = PORTB & 0b11111110;
				break;
		case 1: PORTB = PORTB | 0b00000001;
				break;
		case 2: PORTB = PORTB & 0b11111110; for (Time=20000; Time; Time--);
				PORTB = PORTB | 0b00000001; for (Time=20000; Time; Time--);
				break;
		default: if (PINB & 0b00000001)	PORTB = PORTB & 0b11111110;
								else	PORTB = PORTB | 0b00000001;
				break;
	}
}

int main()
{
	int i;
	Initialize();
	while (1)
	{
		LedMode(0);
		for(i=60000; i; i--);
		LedMode(1);
		for(i=60000; i; i--);
	}
	return 0;
}
